
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class LegacyAMQPTopicBinding
    implements AMQPFilter
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("apache.org:legacy-amqp-topic-binding:string");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000468C00000001", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * value:string
     * 
     */
    protected String value;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, LegacyAMQPTopicBinding.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, LegacyAMQPTopicBinding.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public LegacyAMQPTopicBinding() {
    }

    public LegacyAMQPTopicBinding(String value) {
        this.value = value;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        value = org.fusesource.amqp.types.AMQPString.read(in);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        org.fusesource.amqp.types.AMQPString.write(this.value, out);
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfString(value));
        return fieldSize;
    }

    public long sizeOfBody() {
        return this.sizeOfFields();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.value!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   value:"+ this.value));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[LegacyAMQPTopicBinding"+ rc)+"]");
    }

}
