
package org.fusesource.amqp.types;

import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class LinkError
    extends AMQPSymbol
    implements AMQPErrorCondition
{

    public final static LinkError DETACH_FORCED = new LinkError(new AsciiBuffer("amqp:link:detach-forced"));
    public final static LinkError TRANSFER_LIMIT_EXCEEDED = new LinkError(new AsciiBuffer("amqp:link:transfer-limit-exceeded"));
    public final static LinkError MESSAGE_SIZE_EXCEEDED = new LinkError(new AsciiBuffer("amqp:link:message-size-exceeded"));
    public final static LinkError REDIRECT = new LinkError(new AsciiBuffer("amqp:link:redirect"));
    public final static LinkError STOLEN = new LinkError(new AsciiBuffer("amqp:link:stolen"));

    public LinkError() {
    }

    public LinkError(Buffer value) {
        this.value = value;
    }

    public static LinkError valueOf(Buffer value) {
        if (value == null) {
            return null;
        }
        if (value == DETACH_FORCED.getValue()) {
            return DETACH_FORCED;
        }
        if (value == TRANSFER_LIMIT_EXCEEDED.getValue()) {
            return TRANSFER_LIMIT_EXCEEDED;
        }
        if (value == MESSAGE_SIZE_EXCEEDED.getValue()) {
            return MESSAGE_SIZE_EXCEEDED;
        }
        if (value == REDIRECT.getValue()) {
            return REDIRECT;
        }
        if (value == STOLEN.getValue()) {
            return STOLEN;
        }
        throw new IllegalArgumentException(("invalid LinkError value: "+ value));
    }

}
