
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Modified
    implements AMQPDeliveryState, AMQPOutcome
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:modified:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000027", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * delivery-failed:boolean
     * 
     */
    protected Boolean delivery_failed;
    /**
     * undeliverable-here:boolean
     * 
     */
    protected Boolean undeliverable_here;
    /**
     * message-annotations:fields
     * 
     */
    protected MapEntries message_annotations;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Modified.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Modified.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Modified() {
    }

    public Modified(Boolean delivery_failed) {
        this.delivery_failed = delivery_failed;
    }

    public Modified(Boolean delivery_failed, Boolean undeliverable_here) {
        this.delivery_failed = delivery_failed;
        this.undeliverable_here = undeliverable_here;
    }

    public Modified(Boolean delivery_failed, Boolean undeliverable_here, MapEntries message_annotations) {
        this.delivery_failed = delivery_failed;
        this.undeliverable_here = undeliverable_here;
        this.message_annotations = message_annotations;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public Boolean getDeliveryFailed() {
        return this.delivery_failed;
    }

    public void setDeliveryFailed(Boolean delivery_failed) {
        this.delivery_failed = delivery_failed;
    }

    public Boolean getUndeliverableHere() {
        return this.undeliverable_here;
    }

    public void setUndeliverableHere(Boolean undeliverable_here) {
        this.undeliverable_here = undeliverable_here;
    }

    public MapEntries getMessageAnnotations() {
        return this.message_annotations;
    }

    public void setMessageAnnotations(MapEntries message_annotations) {
        this.message_annotations = message_annotations;
    }

    public int count() {
        int rc = 3;
        if (message_annotations == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (undeliverable_here == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (delivery_failed == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            delivery_failed = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            undeliverable_here = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            message_annotations = org.fusesource.amqp.types.AMQPMap.read(in);
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.delivery_failed, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.undeliverable_here, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPMap.write(this.message_annotations, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(delivery_failed));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(undeliverable_here));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfMap(message_annotations));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.delivery_failed!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   delivery_failed:"+ this.delivery_failed));
        }
        if (this.undeliverable_here!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   undeliverable_here:"+ this.undeliverable_here));
        }
        if (this.message_annotations!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   message_annotations:"+ this.message_annotations));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Modified"+ rc)+"]");
    }

}
