
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import java.util.Arrays;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Open
    implements AMQPFrame
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:open:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000010", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * container-id:string
     * 
     */
    protected String container_id;
    /**
     * hostname:string
     * 
     */
    protected String hostname;
    /**
     * max-frame-size:uint
     * 
     */
    protected Long max_frame_size;
    /**
     * channel-max:ushort
     * 
     */
    protected Integer channel_max;
    /**
     * idle-time-out:milliseconds
     * 
     */
    protected Long idle_time_out;
    /**
     * outgoing-locales:ietf-language-tag
     * 
     */
    protected org.fusesource.amqp.types.AMQPSymbol[] outgoing_locales;
    /**
     * incoming-locales:ietf-language-tag
     * 
     */
    protected org.fusesource.amqp.types.AMQPSymbol[] incoming_locales;
    /**
     * offered-capabilities:symbol
     * 
     */
    protected org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities;
    /**
     * desired-capabilities:symbol
     * 
     */
    protected org.fusesource.amqp.types.AMQPSymbol[] desired_capabilities;
    /**
     * properties:fields
     * 
     */
    protected MapEntries properties;
    public final static Long MAX_FRAME_SIZE_DEFAULT = 4294967295L;
    public final static Integer CHANNEL_MAX_DEFAULT = 65535;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Open.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Open.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Open() {
    }

    public Open(String container_id) {
        this.container_id = container_id;
    }

    public Open(String container_id, String hostname) {
        this.container_id = container_id;
        this.hostname = hostname;
    }

    public Open(String container_id, String hostname, Long max_frame_size) {
        this.container_id = container_id;
        this.hostname = hostname;
        this.max_frame_size = max_frame_size;
    }

    public Open(String container_id, String hostname, Long max_frame_size, Integer channel_max) {
        this.container_id = container_id;
        this.hostname = hostname;
        this.max_frame_size = max_frame_size;
        this.channel_max = channel_max;
    }

    public Open(String container_id, String hostname, Long max_frame_size, Integer channel_max, Long idle_time_out) {
        this.container_id = container_id;
        this.hostname = hostname;
        this.max_frame_size = max_frame_size;
        this.channel_max = channel_max;
        this.idle_time_out = idle_time_out;
    }

    public Open(String container_id, String hostname, Long max_frame_size, Integer channel_max, Long idle_time_out, org.fusesource.amqp.types.AMQPSymbol[] outgoing_locales) {
        this.container_id = container_id;
        this.hostname = hostname;
        this.max_frame_size = max_frame_size;
        this.channel_max = channel_max;
        this.idle_time_out = idle_time_out;
        this.outgoing_locales = outgoing_locales;
    }

    public Open(String container_id, String hostname, Long max_frame_size, Integer channel_max, Long idle_time_out, org.fusesource.amqp.types.AMQPSymbol[] outgoing_locales, org.fusesource.amqp.types.AMQPSymbol[] incoming_locales) {
        this.container_id = container_id;
        this.hostname = hostname;
        this.max_frame_size = max_frame_size;
        this.channel_max = channel_max;
        this.idle_time_out = idle_time_out;
        this.outgoing_locales = outgoing_locales;
        this.incoming_locales = incoming_locales;
    }

    public Open(String container_id, String hostname, Long max_frame_size, Integer channel_max, Long idle_time_out, org.fusesource.amqp.types.AMQPSymbol[] outgoing_locales, org.fusesource.amqp.types.AMQPSymbol[] incoming_locales, org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities) {
        this.container_id = container_id;
        this.hostname = hostname;
        this.max_frame_size = max_frame_size;
        this.channel_max = channel_max;
        this.idle_time_out = idle_time_out;
        this.outgoing_locales = outgoing_locales;
        this.incoming_locales = incoming_locales;
        this.offered_capabilities = offered_capabilities;
    }

    public Open(String container_id, String hostname, Long max_frame_size, Integer channel_max, Long idle_time_out, org.fusesource.amqp.types.AMQPSymbol[] outgoing_locales, org.fusesource.amqp.types.AMQPSymbol[] incoming_locales, org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities, org.fusesource.amqp.types.AMQPSymbol[] desired_capabilities) {
        this.container_id = container_id;
        this.hostname = hostname;
        this.max_frame_size = max_frame_size;
        this.channel_max = channel_max;
        this.idle_time_out = idle_time_out;
        this.outgoing_locales = outgoing_locales;
        this.incoming_locales = incoming_locales;
        this.offered_capabilities = offered_capabilities;
        this.desired_capabilities = desired_capabilities;
    }

    public Open(String container_id, String hostname, Long max_frame_size, Integer channel_max, Long idle_time_out, org.fusesource.amqp.types.AMQPSymbol[] outgoing_locales, org.fusesource.amqp.types.AMQPSymbol[] incoming_locales, org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities, org.fusesource.amqp.types.AMQPSymbol[] desired_capabilities, MapEntries properties) {
        this.container_id = container_id;
        this.hostname = hostname;
        this.max_frame_size = max_frame_size;
        this.channel_max = channel_max;
        this.idle_time_out = idle_time_out;
        this.outgoing_locales = outgoing_locales;
        this.incoming_locales = incoming_locales;
        this.offered_capabilities = offered_capabilities;
        this.desired_capabilities = desired_capabilities;
        this.properties = properties;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public String getContainerID() {
        return this.container_id;
    }

    public void setContainerID(String container_id) {
        this.container_id = container_id;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public Long getMaxFrameSize() {
        return this.max_frame_size;
    }

    public void setMaxFrameSize(Long max_frame_size) {
        this.max_frame_size = max_frame_size;
    }

    public Integer getChannelMax() {
        return this.channel_max;
    }

    public void setChannelMax(Integer channel_max) {
        this.channel_max = channel_max;
    }

    public Long getIdleTimeout() {
        return this.idle_time_out;
    }

    public void setIdleTimeout(Long idle_time_out) {
        this.idle_time_out = idle_time_out;
    }

    public org.fusesource.amqp.types.AMQPSymbol[] getOutgoingLocales() {
        return this.outgoing_locales;
    }

    public void setOutgoingLocales(org.fusesource.amqp.types.AMQPSymbol[] outgoing_locales) {
        this.outgoing_locales = outgoing_locales;
    }

    public org.fusesource.amqp.types.AMQPSymbol[] getIncomingLocales() {
        return this.incoming_locales;
    }

    public void setIncomingLocales(org.fusesource.amqp.types.AMQPSymbol[] incoming_locales) {
        this.incoming_locales = incoming_locales;
    }

    public org.fusesource.amqp.types.AMQPSymbol[] getOfferedCapabilities() {
        return this.offered_capabilities;
    }

    public void setOfferedCapabilities(org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities) {
        this.offered_capabilities = offered_capabilities;
    }

    public org.fusesource.amqp.types.AMQPSymbol[] getDesiredCapabilities() {
        return this.desired_capabilities;
    }

    public void setDesiredCapabilities(org.fusesource.amqp.types.AMQPSymbol[] desired_capabilities) {
        this.desired_capabilities = desired_capabilities;
    }

    public MapEntries getProperties() {
        return this.properties;
    }

    public void setProperties(MapEntries properties) {
        this.properties = properties;
    }

    public int count() {
        int rc = 10;
        if (properties == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (desired_capabilities == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (offered_capabilities == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (incoming_locales == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (outgoing_locales == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (idle_time_out == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (channel_max == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (max_frame_size == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (hostname == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (container_id == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            container_id = org.fusesource.amqp.types.AMQPString.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            hostname = org.fusesource.amqp.types.AMQPString.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            max_frame_size = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            channel_max = org.fusesource.amqp.types.AMQPUShort.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            idle_time_out = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            outgoing_locales = ((org.fusesource.amqp.types.AMQPSymbol[]) AMQPArray.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            incoming_locales = ((org.fusesource.amqp.types.AMQPSymbol[]) AMQPArray.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            offered_capabilities = ((org.fusesource.amqp.types.AMQPSymbol[]) AMQPArray.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            desired_capabilities = ((org.fusesource.amqp.types.AMQPSymbol[]) AMQPArray.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            properties = org.fusesource.amqp.types.AMQPMap.read(in);
        }
        if (container_id == null) {
            throw new RuntimeException("No value specified for mandatory attribute container_id");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPString.write(this.container_id, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPString.write(this.hostname, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.max_frame_size, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUShort.write(this.channel_max, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.idle_time_out, out);
        }
        count = (count- 1);
        if (count >= 0) {
            AMQPArray.write(this.outgoing_locales, out);
        }
        count = (count- 1);
        if (count >= 0) {
            AMQPArray.write(this.incoming_locales, out);
        }
        count = (count- 1);
        if (count >= 0) {
            AMQPArray.write(this.offered_capabilities, out);
        }
        count = (count- 1);
        if (count >= 0) {
            AMQPArray.write(this.desired_capabilities, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPMap.write(this.properties, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfString(container_id));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfString(hostname));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(max_frame_size));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUShort(channel_max));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(idle_time_out));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfArray(outgoing_locales));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfArray(incoming_locales));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfArray(offered_capabilities));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfArray(desired_capabilities));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfMap(properties));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.container_id!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   container_id:"+ this.container_id));
        }
        if (this.hostname!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   hostname:"+ this.hostname));
        }
        if (this.max_frame_size!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   max_frame_size:"+ this.max_frame_size));
        }
        if (this.channel_max!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   channel_max:"+ this.channel_max));
        }
        if (this.idle_time_out!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   idle_time_out:"+ this.idle_time_out));
        }
        if (this.outgoing_locales!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   outgoing_locales:"+ Arrays.toString(this.outgoing_locales)));
        }
        if (this.incoming_locales!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   incoming_locales:"+ Arrays.toString(this.incoming_locales)));
        }
        if (this.offered_capabilities!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   offered_capabilities:"+ Arrays.toString(this.offered_capabilities)));
        }
        if (this.desired_capabilities!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   desired_capabilities:"+ Arrays.toString(this.desired_capabilities)));
        }
        if (this.properties!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   properties:"+ this.properties));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Open"+ rc)+"]");
    }

}
