
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import java.util.Date;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Properties
    implements AMQPSection
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:properties:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000073", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * message-id:*
     * 
     */
    protected org.fusesource.amqp.types.AMQPType message_id;
    /**
     * user-id:binary
     * 
     */
    protected Buffer user_id;
    /**
     * to:*
     * 
     */
    protected org.fusesource.amqp.types.AMQPType to;
    /**
     * subject:string
     * 
     */
    protected String subject;
    /**
     * reply-to:*
     * 
     */
    protected org.fusesource.amqp.types.AMQPType reply_to;
    /**
     * correlation-id:*
     * 
     */
    protected org.fusesource.amqp.types.AMQPType correlation_id;
    /**
     * content-type:symbol
     * 
     */
    protected Buffer content_type;
    /**
     * content-encoding:symbol
     * 
     */
    protected Buffer content_encoding;
    /**
     * absolute-expiry-time:timestamp
     * 
     */
    protected Date absolute_expiry_time;
    /**
     * creation-time:timestamp
     * 
     */
    protected Date creation_time;
    /**
     * group-id:string
     * 
     */
    protected String group_id;
    /**
     * group-sequence:sequence-no
     * 
     */
    protected Long group_sequence;
    /**
     * reply-to-group-id:string
     * 
     */
    protected String reply_to_group_id;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Properties.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Properties.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Properties() {
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id) {
        this.message_id = message_id;
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id, Buffer user_id) {
        this.message_id = message_id;
        this.user_id = user_id;
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id, Buffer user_id, org.fusesource.amqp.types.AMQPType to) {
        this.message_id = message_id;
        this.user_id = user_id;
        this.to = to;
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id, Buffer user_id, org.fusesource.amqp.types.AMQPType to, String subject) {
        this.message_id = message_id;
        this.user_id = user_id;
        this.to = to;
        this.subject = subject;
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id, Buffer user_id, org.fusesource.amqp.types.AMQPType to, String subject, org.fusesource.amqp.types.AMQPType reply_to) {
        this.message_id = message_id;
        this.user_id = user_id;
        this.to = to;
        this.subject = subject;
        this.reply_to = reply_to;
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id, Buffer user_id, org.fusesource.amqp.types.AMQPType to, String subject, org.fusesource.amqp.types.AMQPType reply_to, org.fusesource.amqp.types.AMQPType correlation_id) {
        this.message_id = message_id;
        this.user_id = user_id;
        this.to = to;
        this.subject = subject;
        this.reply_to = reply_to;
        this.correlation_id = correlation_id;
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id, Buffer user_id, org.fusesource.amqp.types.AMQPType to, String subject, org.fusesource.amqp.types.AMQPType reply_to, org.fusesource.amqp.types.AMQPType correlation_id, Buffer content_type) {
        this.message_id = message_id;
        this.user_id = user_id;
        this.to = to;
        this.subject = subject;
        this.reply_to = reply_to;
        this.correlation_id = correlation_id;
        this.content_type = content_type;
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id, Buffer user_id, org.fusesource.amqp.types.AMQPType to, String subject, org.fusesource.amqp.types.AMQPType reply_to, org.fusesource.amqp.types.AMQPType correlation_id, Buffer content_type, Buffer content_encoding) {
        this.message_id = message_id;
        this.user_id = user_id;
        this.to = to;
        this.subject = subject;
        this.reply_to = reply_to;
        this.correlation_id = correlation_id;
        this.content_type = content_type;
        this.content_encoding = content_encoding;
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id, Buffer user_id, org.fusesource.amqp.types.AMQPType to, String subject, org.fusesource.amqp.types.AMQPType reply_to, org.fusesource.amqp.types.AMQPType correlation_id, Buffer content_type, Buffer content_encoding, Date absolute_expiry_time) {
        this.message_id = message_id;
        this.user_id = user_id;
        this.to = to;
        this.subject = subject;
        this.reply_to = reply_to;
        this.correlation_id = correlation_id;
        this.content_type = content_type;
        this.content_encoding = content_encoding;
        this.absolute_expiry_time = absolute_expiry_time;
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id, Buffer user_id, org.fusesource.amqp.types.AMQPType to, String subject, org.fusesource.amqp.types.AMQPType reply_to, org.fusesource.amqp.types.AMQPType correlation_id, Buffer content_type, Buffer content_encoding, Date absolute_expiry_time, Date creation_time) {
        this.message_id = message_id;
        this.user_id = user_id;
        this.to = to;
        this.subject = subject;
        this.reply_to = reply_to;
        this.correlation_id = correlation_id;
        this.content_type = content_type;
        this.content_encoding = content_encoding;
        this.absolute_expiry_time = absolute_expiry_time;
        this.creation_time = creation_time;
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id, Buffer user_id, org.fusesource.amqp.types.AMQPType to, String subject, org.fusesource.amqp.types.AMQPType reply_to, org.fusesource.amqp.types.AMQPType correlation_id, Buffer content_type, Buffer content_encoding, Date absolute_expiry_time, Date creation_time, String group_id) {
        this.message_id = message_id;
        this.user_id = user_id;
        this.to = to;
        this.subject = subject;
        this.reply_to = reply_to;
        this.correlation_id = correlation_id;
        this.content_type = content_type;
        this.content_encoding = content_encoding;
        this.absolute_expiry_time = absolute_expiry_time;
        this.creation_time = creation_time;
        this.group_id = group_id;
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id, Buffer user_id, org.fusesource.amqp.types.AMQPType to, String subject, org.fusesource.amqp.types.AMQPType reply_to, org.fusesource.amqp.types.AMQPType correlation_id, Buffer content_type, Buffer content_encoding, Date absolute_expiry_time, Date creation_time, String group_id, Long group_sequence) {
        this.message_id = message_id;
        this.user_id = user_id;
        this.to = to;
        this.subject = subject;
        this.reply_to = reply_to;
        this.correlation_id = correlation_id;
        this.content_type = content_type;
        this.content_encoding = content_encoding;
        this.absolute_expiry_time = absolute_expiry_time;
        this.creation_time = creation_time;
        this.group_id = group_id;
        this.group_sequence = group_sequence;
    }

    public Properties(org.fusesource.amqp.types.AMQPType message_id, Buffer user_id, org.fusesource.amqp.types.AMQPType to, String subject, org.fusesource.amqp.types.AMQPType reply_to, org.fusesource.amqp.types.AMQPType correlation_id, Buffer content_type, Buffer content_encoding, Date absolute_expiry_time, Date creation_time, String group_id, Long group_sequence, String reply_to_group_id) {
        this.message_id = message_id;
        this.user_id = user_id;
        this.to = to;
        this.subject = subject;
        this.reply_to = reply_to;
        this.correlation_id = correlation_id;
        this.content_type = content_type;
        this.content_encoding = content_encoding;
        this.absolute_expiry_time = absolute_expiry_time;
        this.creation_time = creation_time;
        this.group_id = group_id;
        this.group_sequence = group_sequence;
        this.reply_to_group_id = reply_to_group_id;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public org.fusesource.amqp.types.AMQPType getMessageID() {
        return this.message_id;
    }

    public void setMessageID(org.fusesource.amqp.types.AMQPType message_id) {
        this.message_id = message_id;
    }

    public Buffer getUserID() {
        return this.user_id;
    }

    public void setUserID(Buffer user_id) {
        this.user_id = user_id;
    }

    public org.fusesource.amqp.types.AMQPType getTo() {
        return this.to;
    }

    public void setTo(org.fusesource.amqp.types.AMQPType to) {
        this.to = to;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public org.fusesource.amqp.types.AMQPType getReplyTo() {
        return this.reply_to;
    }

    public void setReplyTo(org.fusesource.amqp.types.AMQPType reply_to) {
        this.reply_to = reply_to;
    }

    public org.fusesource.amqp.types.AMQPType getCorrelationID() {
        return this.correlation_id;
    }

    public void setCorrelationID(org.fusesource.amqp.types.AMQPType correlation_id) {
        this.correlation_id = correlation_id;
    }

    public Buffer getContentType() {
        return this.content_type;
    }

    public void setContentType(Buffer content_type) {
        this.content_type = content_type;
    }

    public Buffer getContentEncoding() {
        return this.content_encoding;
    }

    public void setContentEncoding(Buffer content_encoding) {
        this.content_encoding = content_encoding;
    }

    public Date getAbsoluteExpiryTime() {
        return this.absolute_expiry_time;
    }

    public void setAbsoluteExpiryTime(Date absolute_expiry_time) {
        this.absolute_expiry_time = absolute_expiry_time;
    }

    public Date getCreationTime() {
        return this.creation_time;
    }

    public void setCreationTime(Date creation_time) {
        this.creation_time = creation_time;
    }

    public String getGroupID() {
        return this.group_id;
    }

    public void setGroupID(String group_id) {
        this.group_id = group_id;
    }

    public Long getGroupSequence() {
        return this.group_sequence;
    }

    public void setGroupSequence(Long group_sequence) {
        this.group_sequence = group_sequence;
    }

    public String getReplyToGroupID() {
        return this.reply_to_group_id;
    }

    public void setReplyToGroupID(String reply_to_group_id) {
        this.reply_to_group_id = reply_to_group_id;
    }

    public int count() {
        int rc = 13;
        if (reply_to_group_id == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (group_sequence == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (group_id == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (creation_time == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (absolute_expiry_time == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (content_encoding == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (content_type == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (correlation_id == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (reply_to == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (subject == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (to == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (user_id == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (message_id == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            message_id = ((org.fusesource.amqp.types.AMQPType) org.fusesource.amqp.codec.marshaller.TypeReader.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            user_id = org.fusesource.amqp.types.AMQPBinary.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            to = ((org.fusesource.amqp.types.AMQPType) org.fusesource.amqp.codec.marshaller.TypeReader.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            subject = org.fusesource.amqp.types.AMQPString.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            reply_to = ((org.fusesource.amqp.types.AMQPType) org.fusesource.amqp.codec.marshaller.TypeReader.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            correlation_id = ((org.fusesource.amqp.types.AMQPType) org.fusesource.amqp.codec.marshaller.TypeReader.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            content_type = org.fusesource.amqp.types.AMQPSymbol.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            content_encoding = org.fusesource.amqp.types.AMQPSymbol.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            absolute_expiry_time = org.fusesource.amqp.types.AMQPTimestamp.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            creation_time = org.fusesource.amqp.types.AMQPTimestamp.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            group_id = org.fusesource.amqp.types.AMQPString.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            group_sequence = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            reply_to_group_id = org.fusesource.amqp.types.AMQPString.read(in);
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            if (message_id!= null) {
                message_id.write(out);
            } else {
                out.writeByte(TypeRegistry.NULL_FORMAT_CODE);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBinary.write(this.user_id, out);
        }
        count = (count- 1);
        if (count >= 0) {
            if (to!= null) {
                to.write(out);
            } else {
                out.writeByte(TypeRegistry.NULL_FORMAT_CODE);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPString.write(this.subject, out);
        }
        count = (count- 1);
        if (count >= 0) {
            if (reply_to!= null) {
                reply_to.write(out);
            } else {
                out.writeByte(TypeRegistry.NULL_FORMAT_CODE);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            if (correlation_id!= null) {
                correlation_id.write(out);
            } else {
                out.writeByte(TypeRegistry.NULL_FORMAT_CODE);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPSymbol.write(this.content_type, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPSymbol.write(this.content_encoding, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPTimestamp.write(this.absolute_expiry_time, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPTimestamp.write(this.creation_time, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPString.write(this.group_id, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.group_sequence, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPString.write(this.reply_to_group_id, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            if (message_id!= null) {
                fieldSize = (fieldSize + message_id.size());
            } else {
                fieldSize = (fieldSize + 1L);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBinary(user_id));
        }
        count = (count- 1);
        if (count >= 0) {
            if (to!= null) {
                fieldSize = (fieldSize + to.size());
            } else {
                fieldSize = (fieldSize + 1L);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfString(subject));
        }
        count = (count- 1);
        if (count >= 0) {
            if (reply_to!= null) {
                fieldSize = (fieldSize + reply_to.size());
            } else {
                fieldSize = (fieldSize + 1L);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            if (correlation_id!= null) {
                fieldSize = (fieldSize + correlation_id.size());
            } else {
                fieldSize = (fieldSize + 1L);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfSymbol(content_type));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfSymbol(content_encoding));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfTimestamp(absolute_expiry_time));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfTimestamp(creation_time));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfString(group_id));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(group_sequence));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfString(reply_to_group_id));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.message_id!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   message_id:"+ this.message_id.toString((indent +"   "))));
        }
        if (this.user_id!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   user_id:"+ this.user_id));
        }
        if (this.to!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   to:"+ this.to.toString((indent +"   "))));
        }
        if (this.subject!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   subject:"+ this.subject));
        }
        if (this.reply_to!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   reply_to:"+ this.reply_to.toString((indent +"   "))));
        }
        if (this.correlation_id!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   correlation_id:"+ this.correlation_id.toString((indent +"   "))));
        }
        if (this.content_type!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   content_type:"+ this.content_type));
        }
        if (this.content_encoding!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   content_encoding:"+ this.content_encoding));
        }
        if (this.absolute_expiry_time!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   absolute_expiry_time:"+ this.absolute_expiry_time));
        }
        if (this.creation_time!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   creation_time:"+ this.creation_time));
        }
        if (this.group_id!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   group_id:"+ this.group_id));
        }
        if (this.group_sequence!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   group_sequence:"+ this.group_sequence));
        }
        if (this.reply_to_group_id!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   reply_to_group_id:"+ this.reply_to_group_id));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Properties"+ rc)+"]");
    }

}
