
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Received
    implements AMQPDeliveryState
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:received:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000023", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * section-number:uint
     * 
     */
    protected Long section_number;
    /**
     * section-offset:ulong
     * 
     */
    protected BigInteger section_offset;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Received.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Received.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Received() {
    }

    public Received(Long section_number) {
        this.section_number = section_number;
    }

    public Received(Long section_number, BigInteger section_offset) {
        this.section_number = section_number;
        this.section_offset = section_offset;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public Long getSectionNumber() {
        return this.section_number;
    }

    public void setSectionNumber(Long section_number) {
        this.section_number = section_number;
    }

    public BigInteger getSectionOffset() {
        return this.section_offset;
    }

    public void setSectionOffset(BigInteger section_offset) {
        this.section_offset = section_offset;
    }

    public int count() {
        int rc = 2;
        if (section_offset == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (section_number == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            section_number = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            section_offset = org.fusesource.amqp.types.AMQPULong.read(in);
        }
        if (section_number == null) {
            throw new RuntimeException("No value specified for mandatory attribute section_number");
        }
        if (section_offset == null) {
            throw new RuntimeException("No value specified for mandatory attribute section_offset");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.section_number, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPULong.write(this.section_offset, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(section_number));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfULong(section_offset));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.section_number!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   section_number:"+ this.section_number));
        }
        if (this.section_offset!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   section_offset:"+ this.section_offset));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Received"+ rc)+"]");
    }

}
