
package org.fusesource.amqp.types;


public class ReceiverSettleMode
    extends AMQPUByte
    implements AMQPType
{

    public final static ReceiverSettleMode FIRST = new ReceiverSettleMode(new Short(((short) 0)));
    public final static ReceiverSettleMode SECOND = new ReceiverSettleMode(new Short(((short) 1)));

    public ReceiverSettleMode() {
    }

    public ReceiverSettleMode(Short value) {
        this.value = value;
    }

    public static ReceiverSettleMode valueOf(Short value) {
        if (value == null) {
            return null;
        }
        switch (value.shortValue()) {
            case  0 :
                return FIRST;
            case  1 :
                return SECOND;
        }
        throw new IllegalArgumentException(("invalid ReceiverSettleMode value: "+ value));
    }

}
