
package org.fusesource.amqp.types;


public class Role
    extends AMQPBoolean
    implements AMQPType
{

    public final static Role SENDER = new Role(Boolean.FALSE);
    public final static Role RECEIVER = new Role(Boolean.TRUE);

    public Role() {
    }

    public Role(Boolean value) {
        this.value = value;
    }

    public static Role valueOf(Boolean value) {
        if (value == null) {
            return null;
        }
        if (value == SENDER.getValue()) {
            return SENDER;
        }
        if (value == RECEIVER.getValue()) {
            return RECEIVER;
        }
        throw new IllegalArgumentException(("invalid Role value: "+ value));
    }

}
