
package org.fusesource.amqp.types;


public class SASLCode
    extends AMQPUByte
    implements AMQPType
{

    public final static SASLCode OK = new SASLCode(new Short(((short) 0)));
    public final static SASLCode AUTH = new SASLCode(new Short(((short) 1)));
    public final static SASLCode SYS = new SASLCode(new Short(((short) 2)));
    public final static SASLCode SYS_PERM = new SASLCode(new Short(((short) 3)));
    public final static SASLCode SYS_TEMP = new SASLCode(new Short(((short) 4)));

    public SASLCode() {
    }

    public SASLCode(Short value) {
        this.value = value;
    }

    public static SASLCode valueOf(Short value) {
        if (value == null) {
            return null;
        }
        switch (value.shortValue()) {
            case  0 :
                return OK;
            case  1 :
                return AUTH;
            case  2 :
                return SYS;
            case  3 :
                return SYS_PERM;
            case  4 :
                return SYS_TEMP;
        }
        throw new IllegalArgumentException(("invalid SASLCode value: "+ value));
    }

}
