
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class SASLInit
    implements AMQPSASLFrame
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:sasl-init:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000041", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * mechanism:symbol
     * 
     */
    protected Buffer mechanism;
    /**
     * initial-response:binary
     * 
     */
    protected Buffer initial_response;
    /**
     * hostname:string
     * 
     */
    protected String hostname;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, SASLInit.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, SASLInit.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public SASLInit() {
    }

    public SASLInit(Buffer mechanism) {
        this.mechanism = mechanism;
    }

    public SASLInit(Buffer mechanism, Buffer initial_response) {
        this.mechanism = mechanism;
        this.initial_response = initial_response;
    }

    public SASLInit(Buffer mechanism, Buffer initial_response, String hostname) {
        this.mechanism = mechanism;
        this.initial_response = initial_response;
        this.hostname = hostname;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public Buffer getMechanism() {
        return this.mechanism;
    }

    public void setMechanism(Buffer mechanism) {
        this.mechanism = mechanism;
    }

    public Buffer getInitialResponse() {
        return this.initial_response;
    }

    public void setInitialResponse(Buffer initial_response) {
        this.initial_response = initial_response;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int count() {
        int rc = 3;
        if (hostname == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (initial_response == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (mechanism == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            mechanism = org.fusesource.amqp.types.AMQPSymbol.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            initial_response = org.fusesource.amqp.types.AMQPBinary.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            hostname = org.fusesource.amqp.types.AMQPString.read(in);
        }
        if (mechanism == null) {
            throw new RuntimeException("No value specified for mandatory attribute mechanism");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPSymbol.write(this.mechanism, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBinary.write(this.initial_response, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPString.write(this.hostname, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfSymbol(mechanism));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBinary(initial_response));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfString(hostname));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.mechanism!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   mechanism:"+ this.mechanism));
        }
        if (this.initial_response!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   initial_response:"+ this.initial_response));
        }
        if (this.hostname!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   hostname:"+ this.hostname));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[SASLInit"+ rc)+"]");
    }

}
