
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import java.util.Arrays;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class SASLMechanisms
    implements AMQPSASLFrame
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:sasl-mechanisms:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000040", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * sasl-server-mechanisms:symbol
     * 
     */
    protected AMQPSymbol[] sasl_server_mechanisms;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, SASLMechanisms.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, SASLMechanisms.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public SASLMechanisms() {
    }

    public SASLMechanisms(AMQPSymbol[] sasl_server_mechanisms) {
        this.sasl_server_mechanisms = sasl_server_mechanisms;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public AMQPSymbol[] getSASLServerMechanisms() {
        return this.sasl_server_mechanisms;
    }

    public void setSASLServerMechanisms(AMQPSymbol[] sasl_server_mechanisms) {
        this.sasl_server_mechanisms = sasl_server_mechanisms;
    }

    public int count() {
        int rc = 1;
        if (sasl_server_mechanisms == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            sasl_server_mechanisms = ((AMQPSymbol[]) AMQPArray.read(in));
        }
        if (sasl_server_mechanisms == null) {
            throw new RuntimeException("No value specified for mandatory attribute sasl_server_mechanisms");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            AMQPArray.write(this.sasl_server_mechanisms, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfArray(sasl_server_mechanisms));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.sasl_server_mechanisms!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   sasl_server_mechanisms:"+ Arrays.toString(this.sasl_server_mechanisms)));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[SASLMechanisms"+ rc)+"]");
    }

}
