
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class SASLOutcome
    implements AMQPSASLFrame
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:sasl-outcome:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000044", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * code:sasl-code
     * 
     */
    protected Short code;
    /**
     * additional-data:binary
     * 
     */
    protected Buffer additional_data;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, SASLOutcome.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, SASLOutcome.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public SASLOutcome() {
    }

    public SASLOutcome(Short code) {
        this.code = code;
    }

    public SASLOutcome(Short code, Buffer additional_data) {
        this.code = code;
        this.additional_data = additional_data;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public Short getCode() {
        return this.code;
    }

    public void setCode(Short code) {
        this.code = code;
    }

    public Buffer getAdditionalData() {
        return this.additional_data;
    }

    public void setAdditionalData(Buffer additional_data) {
        this.additional_data = additional_data;
    }

    public int count() {
        int rc = 2;
        if (additional_data == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (code == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            code = org.fusesource.amqp.types.AMQPUByte.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            additional_data = org.fusesource.amqp.types.AMQPBinary.read(in);
        }
        if (code == null) {
            throw new RuntimeException("No value specified for mandatory attribute code");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUByte.write(this.code, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBinary.write(this.additional_data, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUByte(code));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBinary(additional_data));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.code!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   code:"+ this.code));
        }
        if (this.additional_data!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   additional_data:"+ this.additional_data));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[SASLOutcome"+ rc)+"]");
    }

}
