
package org.fusesource.amqp.types;


public class SenderSettleMode
    extends AMQPUByte
    implements AMQPType
{

    public final static SenderSettleMode UNSETTLED = new SenderSettleMode(new Short(((short) 0)));
    public final static SenderSettleMode SETTLED = new SenderSettleMode(new Short(((short) 1)));
    public final static SenderSettleMode MIXED = new SenderSettleMode(new Short(((short) 2)));

    public SenderSettleMode() {
    }

    public SenderSettleMode(Short value) {
        this.value = value;
    }

    public static SenderSettleMode valueOf(Short value) {
        if (value == null) {
            return null;
        }
        switch (value.shortValue()) {
            case  0 :
                return UNSETTLED;
            case  1 :
                return SETTLED;
            case  2 :
                return MIXED;
        }
        throw new IllegalArgumentException(("invalid SenderSettleMode value: "+ value));
    }

}
