
package org.fusesource.amqp.types;

import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class SessionError
    extends AMQPSymbol
    implements AMQPErrorCondition
{

    public final static SessionError WINDOW_VIOLATION = new SessionError(new AsciiBuffer("amqp:session:window-violation"));
    public final static SessionError ERRANT_LINK = new SessionError(new AsciiBuffer("amqp:session:errant-link"));
    public final static SessionError HANDLE_IN_USE = new SessionError(new AsciiBuffer("amqp:session:handle-in-use"));
    public final static SessionError UNATTACHED_HANDLE = new SessionError(new AsciiBuffer("amqp:session:unattached-handle"));

    public SessionError() {
    }

    public SessionError(Buffer value) {
        this.value = value;
    }

    public static SessionError valueOf(Buffer value) {
        if (value == null) {
            return null;
        }
        if (value == WINDOW_VIOLATION.getValue()) {
            return WINDOW_VIOLATION;
        }
        if (value == ERRANT_LINK.getValue()) {
            return ERRANT_LINK;
        }
        if (value == HANDLE_IN_USE.getValue()) {
            return HANDLE_IN_USE;
        }
        if (value == UNATTACHED_HANDLE.getValue()) {
            return UNATTACHED_HANDLE;
        }
        throw new IllegalArgumentException(("invalid SessionError value: "+ value));
    }

}
