
package org.fusesource.amqp.types;

import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class StdDistMode
    extends AMQPSymbol
    implements AMQPDistributionMode
{

    public final static StdDistMode MOVE = new StdDistMode(new AsciiBuffer("move"));
    public final static StdDistMode COPY = new StdDistMode(new AsciiBuffer("copy"));

    public StdDistMode() {
    }

    public StdDistMode(Buffer value) {
        this.value = value;
    }

    public static StdDistMode valueOf(Buffer value) {
        if (value == null) {
            return null;
        }
        if (value == MOVE.getValue()) {
            return MOVE;
        }
        if (value == COPY.getValue()) {
            return COPY;
        }
        throw new IllegalArgumentException(("invalid StdDistMode value: "+ value));
    }

}
