
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import java.util.Arrays;
import org.fusesource.amqp.codec.marshaller.TypeReader;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Target
    implements AMQPTarget
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:target:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000029", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * address:*
     * 
     */
    protected AMQPType address;
    /**
     * durable:terminus-durability
     * 
     */
    protected Long durable;
    /**
     * expiry-policy:terminus-expiry-policy
     * 
     */
    protected Buffer expiry_policy;
    /**
     * timeout:seconds
     * 
     */
    protected Long timeout;
    /**
     * dynamic:boolean
     * 
     */
    protected Boolean dynamic;
    /**
     * dynamic-node-properties:node-properties
     * 
     */
    protected MapEntries dynamic_node_properties;
    /**
     * capabilities:symbol
     * 
     */
    protected org.fusesource.amqp.types.AMQPSymbol[] capabilities;
    public final static Buffer EXPIRY_POLICY_DEFAULT = Buffer.ascii("session-end");
    public final static Long TIMEOUT_DEFAULT = 0L;
    public final static Boolean DYNAMIC_DEFAULT = false;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Target.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Target.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Target() {
    }

    public Target(AMQPType address) {
        this.address = address;
    }

    public Target(AMQPType address, Long durable) {
        this.address = address;
        this.durable = durable;
    }

    public Target(AMQPType address, Long durable, Buffer expiry_policy) {
        this.address = address;
        this.durable = durable;
        this.expiry_policy = expiry_policy;
    }

    public Target(AMQPType address, Long durable, Buffer expiry_policy, Long timeout) {
        this.address = address;
        this.durable = durable;
        this.expiry_policy = expiry_policy;
        this.timeout = timeout;
    }

    public Target(AMQPType address, Long durable, Buffer expiry_policy, Long timeout, Boolean dynamic) {
        this.address = address;
        this.durable = durable;
        this.expiry_policy = expiry_policy;
        this.timeout = timeout;
        this.dynamic = dynamic;
    }

    public Target(AMQPType address, Long durable, Buffer expiry_policy, Long timeout, Boolean dynamic, MapEntries dynamic_node_properties) {
        this.address = address;
        this.durable = durable;
        this.expiry_policy = expiry_policy;
        this.timeout = timeout;
        this.dynamic = dynamic;
        this.dynamic_node_properties = dynamic_node_properties;
    }

    public Target(AMQPType address, Long durable, Buffer expiry_policy, Long timeout, Boolean dynamic, MapEntries dynamic_node_properties, org.fusesource.amqp.types.AMQPSymbol[] capabilities) {
        this.address = address;
        this.durable = durable;
        this.expiry_policy = expiry_policy;
        this.timeout = timeout;
        this.dynamic = dynamic;
        this.dynamic_node_properties = dynamic_node_properties;
        this.capabilities = capabilities;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public AMQPType getAddress() {
        return this.address;
    }

    public void setAddress(AMQPType address) {
        this.address = address;
    }

    public Long getDurable() {
        return this.durable;
    }

    public void setDurable(Long durable) {
        this.durable = durable;
    }

    public Buffer getExpiryPolicy() {
        return this.expiry_policy;
    }

    public void setExpiryPolicy(Buffer expiry_policy) {
        this.expiry_policy = expiry_policy;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public Boolean getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
    }

    public MapEntries getDynamicNodeProperties() {
        return this.dynamic_node_properties;
    }

    public void setDynamicNodeProperties(MapEntries dynamic_node_properties) {
        this.dynamic_node_properties = dynamic_node_properties;
    }

    public org.fusesource.amqp.types.AMQPSymbol[] getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(org.fusesource.amqp.types.AMQPSymbol[] capabilities) {
        this.capabilities = capabilities;
    }

    public int count() {
        int rc = 7;
        if (capabilities == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (dynamic_node_properties == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (dynamic == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (timeout == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (expiry_policy == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (durable == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (address == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            address = ((AMQPType) TypeReader.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            durable = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            expiry_policy = org.fusesource.amqp.types.AMQPSymbol.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            timeout = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            dynamic = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            dynamic_node_properties = org.fusesource.amqp.types.AMQPMap.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            capabilities = ((org.fusesource.amqp.types.AMQPSymbol[]) AMQPArray.read(in));
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            if (address!= null) {
                address.write(out);
            } else {
                out.writeByte(TypeRegistry.NULL_FORMAT_CODE);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.durable, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPSymbol.write(this.expiry_policy, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.timeout, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.dynamic, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPMap.write(this.dynamic_node_properties, out);
        }
        count = (count- 1);
        if (count >= 0) {
            AMQPArray.write(this.capabilities, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            if (address!= null) {
                fieldSize = (fieldSize + address.size());
            } else {
                fieldSize = (fieldSize + 1L);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(durable));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfSymbol(expiry_policy));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(timeout));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(dynamic));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfMap(dynamic_node_properties));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfArray(capabilities));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.address!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   address:"+ this.address.toString((indent +"   "))));
        }
        if (this.durable!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   durable:"+ this.durable));
        }
        if (this.expiry_policy!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   expiry_policy:"+ this.expiry_policy));
        }
        if (this.timeout!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   timeout:"+ this.timeout));
        }
        if (this.dynamic!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   dynamic:"+ this.dynamic));
        }
        if (this.dynamic_node_properties!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   dynamic_node_properties:"+ this.dynamic_node_properties));
        }
        if (this.capabilities!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   capabilities:"+ Arrays.toString(this.capabilities)));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Target"+ rc)+"]");
    }

}
