
package org.fusesource.amqp.types;


public class TerminusDurability
    extends AMQPUInt
    implements AMQPType
{

    public final static TerminusDurability NONE = new TerminusDurability(new Long(0L));
    public final static TerminusDurability CONFIGURATION = new TerminusDurability(new Long(1L));
    public final static TerminusDurability UNSETTLED_STATE = new TerminusDurability(new Long(2L));

    public TerminusDurability() {
    }

    public TerminusDurability(Long value) {
        this.value = value;
    }

    public static TerminusDurability valueOf(Long value) {
        if (value == null) {
            return null;
        }
        switch (value.intValue()) {
            case  0 :
                return NONE;
            case  1 :
                return CONFIGURATION;
            case  2 :
                return UNSETTLED_STATE;
        }
        throw new IllegalArgumentException(("invalid TerminusDurability value: "+ value));
    }

}
