
package org.fusesource.amqp.types;

import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class TerminusExpiryPolicy
    extends AMQPSymbol
    implements AMQPType
{

    public final static TerminusExpiryPolicy LINK_DETACH = new TerminusExpiryPolicy(new AsciiBuffer("link-detach"));
    public final static TerminusExpiryPolicy SESSION_END = new TerminusExpiryPolicy(new AsciiBuffer("session-end"));
    public final static TerminusExpiryPolicy CONNECTION_CLOSE = new TerminusExpiryPolicy(new AsciiBuffer("connection-close"));
    public final static TerminusExpiryPolicy NEVER = new TerminusExpiryPolicy(new AsciiBuffer("never"));

    public TerminusExpiryPolicy() {
    }

    public TerminusExpiryPolicy(Buffer value) {
        this.value = value;
    }

    public static TerminusExpiryPolicy valueOf(Buffer value) {
        if (value == null) {
            return null;
        }
        if (value == LINK_DETACH.getValue()) {
            return LINK_DETACH;
        }
        if (value == SESSION_END.getValue()) {
            return SESSION_END;
        }
        if (value == CONNECTION_CLOSE.getValue()) {
            return CONNECTION_CLOSE;
        }
        if (value == NEVER.getValue()) {
            return NEVER;
        }
        throw new IllegalArgumentException(("invalid TerminusExpiryPolicy value: "+ value));
    }

}
