
package org.fusesource.amqp.types;

import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class TransactionError
    extends AMQPSymbol
    implements AMQPErrorCondition
{

    public final static TransactionError UNKNOWN_ID = new TransactionError(new AsciiBuffer("amqp:transaction:unknown-id"));
    public final static TransactionError TRANSACTION_ROLLBACK = new TransactionError(new AsciiBuffer("amqp:transaction:rollback"));
    public final static TransactionError TRANSACTION_TIMEOUT = new TransactionError(new AsciiBuffer("amqp:transaction:timeout"));

    public TransactionError() {
    }

    public TransactionError(Buffer value) {
        this.value = value;
    }

    public static TransactionError valueOf(Buffer value) {
        if (value == null) {
            return null;
        }
        if (value == UNKNOWN_ID.getValue()) {
            return UNKNOWN_ID;
        }
        if (value == TRANSACTION_ROLLBACK.getValue()) {
            return TRANSACTION_ROLLBACK;
        }
        if (value == TRANSACTION_TIMEOUT.getValue()) {
            return TRANSACTION_TIMEOUT;
        }
        throw new IllegalArgumentException(("invalid TransactionError value: "+ value));
    }

}
