
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class TransactionalState
    implements AMQPDeliveryState
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:transactional-state:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000034", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * txn-id:*
     * 
     */
    protected org.fusesource.amqp.types.AMQPType txn_id;
    /**
     * outcome:*
     * 
     */
    protected org.fusesource.amqp.types.AMQPType outcome;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, TransactionalState.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, TransactionalState.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public TransactionalState() {
    }

    public TransactionalState(org.fusesource.amqp.types.AMQPType txn_id) {
        this.txn_id = txn_id;
    }

    public TransactionalState(org.fusesource.amqp.types.AMQPType txn_id, org.fusesource.amqp.types.AMQPType outcome) {
        this.txn_id = txn_id;
        this.outcome = outcome;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public org.fusesource.amqp.types.AMQPType getTxnID() {
        return this.txn_id;
    }

    public void setTxnID(org.fusesource.amqp.types.AMQPType txn_id) {
        this.txn_id = txn_id;
    }

    public org.fusesource.amqp.types.AMQPType getOutcome() {
        return this.outcome;
    }

    public void setOutcome(org.fusesource.amqp.types.AMQPType outcome) {
        this.outcome = outcome;
    }

    public int count() {
        int rc = 2;
        if (outcome == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (txn_id == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            txn_id = ((org.fusesource.amqp.types.AMQPType) org.fusesource.amqp.codec.marshaller.TypeReader.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            outcome = ((org.fusesource.amqp.types.AMQPType) org.fusesource.amqp.codec.marshaller.TypeReader.read(in));
        }
        if (txn_id == null) {
            throw new RuntimeException("No value specified for mandatory attribute txn_id");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            if (txn_id!= null) {
                txn_id.write(out);
            } else {
                out.writeByte(TypeRegistry.NULL_FORMAT_CODE);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            if (outcome!= null) {
                outcome.write(out);
            } else {
                out.writeByte(TypeRegistry.NULL_FORMAT_CODE);
            }
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            if (txn_id!= null) {
                fieldSize = (fieldSize + txn_id.size());
            } else {
                fieldSize = (fieldSize + 1L);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            if (outcome!= null) {
                fieldSize = (fieldSize + outcome.size());
            } else {
                fieldSize = (fieldSize + 1L);
            }
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.txn_id!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   txn_id:"+ this.txn_id.toString((indent +"   "))));
        }
        if (this.outcome!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   outcome:"+ this.outcome.toString((indent +"   "))));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[TransactionalState"+ rc)+"]");
    }

}
