
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeReader;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Transfer
    implements AMQPFrame
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:transfer:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000014", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * handle:handle
     * 
     */
    protected Long handle;
    /**
     * delivery-id:delivery-number
     * 
     */
    protected Long delivery_id;
    /**
     * delivery-tag:delivery-tag
     * 
     */
    protected Buffer delivery_tag;
    /**
     * message-format:message-format
     * 
     */
    protected Long message_format;
    /**
     * settled:boolean
     * 
     */
    protected Boolean settled;
    /**
     * more:boolean
     * 
     */
    protected Boolean more;
    /**
     * rcv-settle-mode:receiver-settle-mode
     * 
     */
    protected Short rcv_settle_mode;
    /**
     * state:*
     * 
     */
    protected AMQPType state;
    /**
     * resume:boolean
     * 
     */
    protected Boolean resume;
    /**
     * aborted:boolean
     * 
     */
    protected Boolean aborted;
    /**
     * batchable:boolean
     * 
     */
    protected Boolean batchable;
    public final static Boolean MORE_DEFAULT = false;
    public final static Boolean RESUME_DEFAULT = false;
    public final static Boolean ABORTED_DEFAULT = false;
    public final static Boolean BATCHABLE_DEFAULT = false;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Transfer.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Transfer.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Transfer() {
    }

    public Transfer(Long handle) {
        this.handle = handle;
    }

    public Transfer(Long handle, Long delivery_id) {
        this.handle = handle;
        this.delivery_id = delivery_id;
    }

    public Transfer(Long handle, Long delivery_id, Buffer delivery_tag) {
        this.handle = handle;
        this.delivery_id = delivery_id;
        this.delivery_tag = delivery_tag;
    }

    public Transfer(Long handle, Long delivery_id, Buffer delivery_tag, Long message_format) {
        this.handle = handle;
        this.delivery_id = delivery_id;
        this.delivery_tag = delivery_tag;
        this.message_format = message_format;
    }

    public Transfer(Long handle, Long delivery_id, Buffer delivery_tag, Long message_format, Boolean settled) {
        this.handle = handle;
        this.delivery_id = delivery_id;
        this.delivery_tag = delivery_tag;
        this.message_format = message_format;
        this.settled = settled;
    }

    public Transfer(Long handle, Long delivery_id, Buffer delivery_tag, Long message_format, Boolean settled, Boolean more) {
        this.handle = handle;
        this.delivery_id = delivery_id;
        this.delivery_tag = delivery_tag;
        this.message_format = message_format;
        this.settled = settled;
        this.more = more;
    }

    public Transfer(Long handle, Long delivery_id, Buffer delivery_tag, Long message_format, Boolean settled, Boolean more, Short rcv_settle_mode) {
        this.handle = handle;
        this.delivery_id = delivery_id;
        this.delivery_tag = delivery_tag;
        this.message_format = message_format;
        this.settled = settled;
        this.more = more;
        this.rcv_settle_mode = rcv_settle_mode;
    }

    public Transfer(Long handle, Long delivery_id, Buffer delivery_tag, Long message_format, Boolean settled, Boolean more, Short rcv_settle_mode, AMQPType state) {
        this.handle = handle;
        this.delivery_id = delivery_id;
        this.delivery_tag = delivery_tag;
        this.message_format = message_format;
        this.settled = settled;
        this.more = more;
        this.rcv_settle_mode = rcv_settle_mode;
        this.state = state;
    }

    public Transfer(Long handle, Long delivery_id, Buffer delivery_tag, Long message_format, Boolean settled, Boolean more, Short rcv_settle_mode, AMQPType state, Boolean resume) {
        this.handle = handle;
        this.delivery_id = delivery_id;
        this.delivery_tag = delivery_tag;
        this.message_format = message_format;
        this.settled = settled;
        this.more = more;
        this.rcv_settle_mode = rcv_settle_mode;
        this.state = state;
        this.resume = resume;
    }

    public Transfer(Long handle, Long delivery_id, Buffer delivery_tag, Long message_format, Boolean settled, Boolean more, Short rcv_settle_mode, AMQPType state, Boolean resume, Boolean aborted) {
        this.handle = handle;
        this.delivery_id = delivery_id;
        this.delivery_tag = delivery_tag;
        this.message_format = message_format;
        this.settled = settled;
        this.more = more;
        this.rcv_settle_mode = rcv_settle_mode;
        this.state = state;
        this.resume = resume;
        this.aborted = aborted;
    }

    public Transfer(Long handle, Long delivery_id, Buffer delivery_tag, Long message_format, Boolean settled, Boolean more, Short rcv_settle_mode, AMQPType state, Boolean resume, Boolean aborted, Boolean batchable) {
        this.handle = handle;
        this.delivery_id = delivery_id;
        this.delivery_tag = delivery_tag;
        this.message_format = message_format;
        this.settled = settled;
        this.more = more;
        this.rcv_settle_mode = rcv_settle_mode;
        this.state = state;
        this.resume = resume;
        this.aborted = aborted;
        this.batchable = batchable;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public Long getHandle() {
        return this.handle;
    }

    public void setHandle(Long handle) {
        this.handle = handle;
    }

    public Long getDeliveryID() {
        return this.delivery_id;
    }

    public void setDeliveryID(Long delivery_id) {
        this.delivery_id = delivery_id;
    }

    public Buffer getDeliveryTag() {
        return this.delivery_tag;
    }

    public void setDeliveryTag(Buffer delivery_tag) {
        this.delivery_tag = delivery_tag;
    }

    public Long getMessageFormat() {
        return this.message_format;
    }

    public void setMessageFormat(Long message_format) {
        this.message_format = message_format;
    }

    public Boolean getSettled() {
        return this.settled;
    }

    public void setSettled(Boolean settled) {
        this.settled = settled;
    }

    public Boolean getMore() {
        return this.more;
    }

    public void setMore(Boolean more) {
        this.more = more;
    }

    public Short getRcvSettleMode() {
        return this.rcv_settle_mode;
    }

    public void setRcvSettleMode(Short rcv_settle_mode) {
        this.rcv_settle_mode = rcv_settle_mode;
    }

    public AMQPType getState() {
        return this.state;
    }

    public void setState(AMQPType state) {
        this.state = state;
    }

    public Boolean getResume() {
        return this.resume;
    }

    public void setResume(Boolean resume) {
        this.resume = resume;
    }

    public Boolean getAborted() {
        return this.aborted;
    }

    public void setAborted(Boolean aborted) {
        this.aborted = aborted;
    }

    public Boolean getBatchable() {
        return this.batchable;
    }

    public void setBatchable(Boolean batchable) {
        this.batchable = batchable;
    }

    public int count() {
        int rc = 11;
        if (batchable == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (aborted == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (resume == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (state == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (rcv_settle_mode == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (more == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (settled == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (message_format == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (delivery_tag == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (delivery_id == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (handle == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            handle = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            delivery_id = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            delivery_tag = org.fusesource.amqp.types.AMQPBinary.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            message_format = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            settled = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            more = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            rcv_settle_mode = org.fusesource.amqp.types.AMQPUByte.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            state = ((AMQPType) TypeReader.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            resume = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            aborted = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            batchable = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        if (handle == null) {
            throw new RuntimeException("No value specified for mandatory attribute handle");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.handle, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.delivery_id, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBinary.write(this.delivery_tag, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.message_format, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.settled, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.more, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUByte.write(this.rcv_settle_mode, out);
        }
        count = (count- 1);
        if (count >= 0) {
            if (state!= null) {
                state.write(out);
            } else {
                out.writeByte(TypeRegistry.NULL_FORMAT_CODE);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.resume, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.aborted, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.batchable, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(handle));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(delivery_id));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBinary(delivery_tag));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(message_format));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(settled));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(more));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUByte(rcv_settle_mode));
        }
        count = (count- 1);
        if (count >= 0) {
            if (state!= null) {
                fieldSize = (fieldSize + state.size());
            } else {
                fieldSize = (fieldSize + 1L);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(resume));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(aborted));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(batchable));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.handle!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   handle:"+ this.handle));
        }
        if (this.delivery_id!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   delivery_id:"+ this.delivery_id));
        }
        if (this.delivery_tag!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   delivery_tag:"+ this.delivery_tag));
        }
        if (this.message_format!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   message_format:"+ this.message_format));
        }
        if (this.settled!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   settled:"+ this.settled));
        }
        if (this.more!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   more:"+ this.more));
        }
        if (this.rcv_settle_mode!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   rcv_settle_mode:"+ this.rcv_settle_mode));
        }
        if (this.state!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   state:"+ this.state.toString((indent +"   "))));
        }
        if (this.resume!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   resume:"+ this.resume));
        }
        if (this.aborted!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   aborted:"+ this.aborted));
        }
        if (this.batchable!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   batchable:"+ this.batchable));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Transfer"+ rc)+"]");
    }

}
