
package org.fusesource.amqp.types;

import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class TxnCapability
    extends AMQPSymbol
    implements AMQPTxnCapability
{

    public final static TxnCapability LOCAL_TRANSACTIONS = new TxnCapability(new AsciiBuffer("amqp:local-transactions"));
    public final static TxnCapability DISTRIBUTED_TRANSACTIONS = new TxnCapability(new AsciiBuffer("amqp:distributed-transactions"));
    public final static TxnCapability PROMOTABLE_TRANSACTIONS = new TxnCapability(new AsciiBuffer("amqp:promotable-transactions"));
    public final static TxnCapability MULTI_TXNS_PER_SSN = new TxnCapability(new AsciiBuffer("amqp:multi-txns-per-ssn"));
    public final static TxnCapability MULTI_SSNS_PER_TXN = new TxnCapability(new AsciiBuffer("amqp:multi-ssns-per-txn"));

    public TxnCapability() {
    }

    public TxnCapability(Buffer value) {
        this.value = value;
    }

    public static TxnCapability valueOf(Buffer value) {
        if (value == null) {
            return null;
        }
        if (value == LOCAL_TRANSACTIONS.getValue()) {
            return LOCAL_TRANSACTIONS;
        }
        if (value == DISTRIBUTED_TRANSACTIONS.getValue()) {
            return DISTRIBUTED_TRANSACTIONS;
        }
        if (value == PROMOTABLE_TRANSACTIONS.getValue()) {
            return PROMOTABLE_TRANSACTIONS;
        }
        if (value == MULTI_TXNS_PER_SSN.getValue()) {
            return MULTI_TXNS_PER_SSN;
        }
        if (value == MULTI_SSNS_PER_TXN.getValue()) {
            return MULTI_SSNS_PER_TXN;
        }
        throw new IllegalArgumentException(("invalid TxnCapability value: "+ value));
    }

}
