/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.generator;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtjni.generator.JNIGenerator;
import org.fusesource.hawtjni.generator.model.JNIClass;
import org.fusesource.hawtjni.generator.model.JNIField;
import org.fusesource.hawtjni.generator.model.JNIType;
import org.fusesource.hawtjni.runtime.ClassFlag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructsGenerator
extends JNIGenerator {
    boolean header;
    static final boolean GLOBAL_REF = false;

    public StructsGenerator(boolean header) {
        this.header = header;
    }

    @Override
    public void generateCopyright() {
        this.outputln(StructsGenerator.fixDelimiter(this.getCopyright()));
    }

    @Override
    public void generateIncludes() {
        if (this.header) {
            this.outputln("#include \"" + this.getOutputName() + ".h\"");
        } else {
            this.outputln("#include \"" + this.getOutputName() + ".h\"");
            this.outputln("#include \"hawtjni.h\"");
            this.outputln("#include \"" + this.getOutputName() + "_structs.h\"");
        }
        this.outputln();
    }

    @Override
    public void generate(JNIClass clazz) {
        ArrayList<JNIField> fields = this.getStructFields(clazz);
        if (fields.isEmpty()) {
            return;
        }
        if (this.header) {
            this.generateHeaderFile(clazz);
        } else {
            this.generateSourceFile(clazz);
        }
    }

    private ArrayList<JNIField> getStructFields(JNIClass clazz) {
        ArrayList<JNIField> rc = new ArrayList<JNIField>();
        List<JNIField> fields = clazz.getDeclaredFields();
        for (JNIField field : fields) {
            int mods = field.getModifiers();
            if ((mods & 8) != 0 || (mods & 0x80) != 0) continue;
            rc.add(field);
        }
        return rc;
    }

    void generateHeaderFile(JNIClass clazz) {
        this.generateSourceStart(clazz);
        this.generatePrototypes(clazz);
        this.generateBlankMacros(clazz);
        this.generateSourceEnd(clazz);
        this.outputln();
    }

    void generateSourceFile(JNIClass clazz) {
        this.generateSourceStart(clazz);
        this.generateFIDsStructure(clazz);
        this.outputln();
        this.generateGlobalVar(clazz);
        this.outputln();
        this.generateFunctions(clazz);
        this.generateSourceEnd(clazz);
        this.outputln();
    }

    void generateSourceStart(JNIClass clazz) {
        String conditional = clazz.getConditional();
        if (conditional != null) {
            this.outputln("#if " + conditional);
        }
    }

    void generateSourceEnd(JNIClass clazz) {
        if (clazz.getConditional() != null) {
            this.outputln("#endif");
        }
    }

    void generateGlobalVar(JNIClass clazz) {
        String simpleName = clazz.getSimpleName();
        this.output(simpleName);
        this.output("_FID_CACHE ");
        this.output(simpleName);
        this.outputln("Fc;");
    }

    void generateBlankMacros(JNIClass clazz) {
        if (clazz.getConditional() == null) {
            return;
        }
        String simpleName = clazz.getSimpleName();
        this.outputln("#else");
        this.output("#define cache");
        this.output(simpleName);
        this.outputln("Fields(a,b)");
        this.output("#define get");
        this.output(simpleName);
        this.outputln("Fields(a,b,c) NULL");
        this.output("#define set");
        this.output(simpleName);
        this.outputln("Fields(a,b,c)");
    }

    void generatePrototypes(JNIClass clazz) {
        String clazzName = clazz.getNativeName();
        String simpleName = clazz.getSimpleName();
        this.output("void cache");
        this.output(simpleName);
        this.outputln("Fields(JNIEnv *env, jobject lpObject);");
        if (clazz.getFlag(ClassFlag.STRUCT) && !clazz.getFlag(ClassFlag.TYPEDEF)) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.output(" *get");
        this.output(simpleName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        if (clazz.getFlag(ClassFlag.STRUCT) && !clazz.getFlag(ClassFlag.TYPEDEF)) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.outputln(" *lpStruct);");
        this.output("void set");
        this.output(simpleName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        if (clazz.getFlag(ClassFlag.STRUCT) && !clazz.getFlag(ClassFlag.TYPEDEF)) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.outputln(" *lpStruct);");
    }

    void generateFIDsStructure(JNIClass clazz) {
        String simpleName = clazz.getSimpleName();
        this.output("typedef struct ");
        this.output(simpleName);
        this.outputln("_FID_CACHE {");
        this.outputln("\tint cached;");
        this.outputln("\tjclass clazz;");
        this.output("\tjfieldID ");
        List<JNIField> fields = clazz.getDeclaredFields();
        boolean first = true;
        for (JNIField field : fields) {
            if (this.ignoreField(field)) continue;
            if (!first) {
                this.output(", ");
            }
            this.output(field.getName());
            first = false;
        }
        this.outputln(";");
        this.output("} ");
        this.output(simpleName);
        this.outputln("_FID_CACHE;");
    }

    void generateCacheFunction(JNIClass clazz) {
        String simpleName = clazz.getSimpleName();
        String clazzName = clazz.getNativeName();
        this.output("void cache");
        this.output(simpleName);
        this.outputln("Fields(JNIEnv *env, jobject lpObject)");
        this.outputln("{");
        this.output("\tif (");
        this.output(simpleName);
        this.outputln("Fc.cached) return;");
        JNIClass superclazz = clazz.getSuperclass();
        if (!superclazz.getName().equals("java.lang.Object")) {
            String superName = superclazz.getSimpleName();
            this.output("\tcache");
            this.output(superName);
            this.outputln("Fields(env, lpObject);");
        }
        this.output("\t");
        this.output(simpleName);
        if (this.isCPP) {
            this.output("Fc.clazz = env->GetObjectClass(lpObject);");
        } else {
            this.output("Fc.clazz = (*env)->GetObjectClass(env, lpObject);");
        }
        this.outputln();
        List<JNIField> fields = clazz.getDeclaredFields();
        for (JNIField field : fields) {
            if (this.ignoreField(field)) continue;
            this.output("\t");
            this.output(simpleName);
            this.output("Fc.");
            this.output(field.getName());
            if (this.isCPP) {
                this.output(" = env->GetFieldID(");
            } else {
                this.output(" = (*env)->GetFieldID(env, ");
            }
            this.output(simpleName);
            this.output("Fc.clazz, \"");
            this.output(field.getName());
            JNIType type = field.getType();
            JNIType type64 = field.getType64();
            this.output("\", ");
            if (type.equals(type64)) {
                this.output("\"");
            }
            this.output(type.getTypeSignature(!type.equals(type64)));
            if (type.equals(type64)) {
                this.output("\"");
            }
            this.outputln(");");
        }
        this.output("\t");
        this.output(simpleName);
        this.outputln("Fc.cached = 1;");
        this.outputln("}");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void generateGetFields(JNIClass clazz) {
        JNIClass superclazz = clazz.getSuperclass();
        String clazzName = clazz.getNativeName();
        String superName = superclazz.getNativeName();
        if (!superclazz.getName().equals("java.lang.Object")) {
            if (!clazzName.equals(superName + "A") && !clazzName.equals(superName + "W")) {
                this.output("\tget");
                this.output(superName);
                this.output("Fields(env, lpObject, (");
                this.output(superName);
                this.outputln(" *)lpStruct);");
            } else {
                this.generateGetFields(superclazz);
            }
        }
        List<JNIField> fields = clazz.getDeclaredFields();
        for (JNIField field : fields) {
            if (this.ignoreField(field)) continue;
            String conditional = field.getConditional();
            if (conditional != null) {
                this.outputln("#if " + conditional);
            }
            JNIType type = field.getType();
            JNIType type64 = field.getType64();
            String simpleName = type.getSimpleName();
            String accessor = field.getAccessor();
            if (accessor == null || accessor.length() == 0) {
                accessor = field.getName();
            }
            if (type.isPrimitive()) {
                this.output("\tlpStruct->");
                this.output(accessor);
                this.output(" = ");
                this.output(field.getCast());
                if (field.isPointer()) {
                    this.output("(intptr_t)");
                }
                if (this.isCPP) {
                    this.output("env->Get");
                } else {
                    this.output("(*env)->Get");
                }
                this.output(type.getTypeSignature1(!type.equals(type64)));
                if (this.isCPP) {
                    this.output("Field(lpObject, ");
                } else {
                    this.output("Field(env, lpObject, ");
                }
                this.output(field.getDeclaringClass().getSimpleName());
                this.output("Fc.");
                this.output(field.getName());
                this.output(");");
            } else if (type.isArray()) {
                JNIType componentType = type.getComponentType();
                JNIType componentType64 = type64.getComponentType();
                if (!componentType.isPrimitive()) throw new Error("not done");
                this.outputln("\t{");
                this.output("\t");
                this.output(type.getTypeSignature2(!type.equals(type64)));
                this.output(" lpObject1 = (");
                this.output(type.getTypeSignature2(!type.equals(type64)));
                if (this.isCPP) {
                    this.output(")env->GetObjectField(lpObject, ");
                } else {
                    this.output(")(*env)->GetObjectField(env, lpObject, ");
                }
                this.output(field.getDeclaringClass().getSimpleName());
                this.output("Fc.");
                this.output(field.getName());
                this.outputln(");");
                if (this.isCPP) {
                    this.output("\tenv->Get");
                } else {
                    this.output("\t(*env)->Get");
                }
                this.output(componentType.getTypeSignature1(!componentType.equals(componentType64)));
                if (this.isCPP) {
                    this.output("ArrayRegion(lpObject1, 0, sizeof(lpStruct->");
                } else {
                    this.output("ArrayRegion(env, lpObject1, 0, sizeof(lpStruct->");
                }
                this.output(accessor);
                this.output(")");
                if (!componentType.isType("byte")) {
                    this.output(" / sizeof(");
                    this.output(componentType.getTypeSignature2(!componentType.equals(componentType64)));
                    this.output(")");
                }
                this.output(", (");
                this.output(type.getTypeSignature4(!type.equals(type64), false));
                this.output(")lpStruct->");
                this.output(accessor);
                this.outputln(");");
                this.output("\t}");
            } else {
                this.outputln("\t{");
                if (this.isCPP) {
                    this.output("\tjobject lpObject1 = env->GetObjectField(lpObject, ");
                } else {
                    this.output("\tjobject lpObject1 = (*env)->GetObjectField(env, lpObject, ");
                }
                this.output(field.getDeclaringClass().getSimpleName());
                this.output("Fc.");
                this.output(field.getName());
                this.outputln(");");
                this.output("\tif (lpObject1 != NULL) get");
                this.output(simpleName);
                this.output("Fields(env, lpObject1, &lpStruct->");
                this.output(accessor);
                this.outputln(");");
                this.output("\t}");
            }
            this.outputln();
            if (conditional == null) continue;
            this.outputln("#endif");
        }
    }

    void generateGetFunction(JNIClass clazz) {
        String clazzName = clazz.getNativeName();
        String simpleName = clazz.getSimpleName();
        if (clazz.getFlag(ClassFlag.STRUCT) && !clazz.getFlag(ClassFlag.TYPEDEF)) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.output(" *get");
        this.output(simpleName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        if (clazz.getFlag(ClassFlag.STRUCT) && !clazz.getFlag(ClassFlag.TYPEDEF)) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.outputln(" *lpStruct)");
        this.outputln("{");
        this.output("\tif (!");
        this.output(simpleName);
        this.output("Fc.cached) cache");
        this.output(simpleName);
        this.outputln("Fields(env, lpObject);");
        if (clazz.getFlag(ClassFlag.ZERO_OUT)) {
            this.outputln("memset(lpStruct, 0, sizeof(struct " + clazzName + "));");
        }
        this.generateGetFields(clazz);
        this.outputln("\treturn lpStruct;");
        this.outputln("}");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void generateSetFields(JNIClass clazz) {
        JNIClass superclazz = clazz.getSuperclass();
        String clazzName = clazz.getNativeName();
        String superName = superclazz.getNativeName();
        if (!superclazz.getName().equals("java.lang.Object")) {
            if (!clazzName.equals(superName + "A") && !clazzName.equals(superName + "W")) {
                this.output("\tset");
                this.output(superName);
                this.output("Fields(env, lpObject, (");
                this.output(superName);
                this.outputln(" *)lpStruct);");
            } else {
                this.generateSetFields(superclazz);
            }
        }
        List<JNIField> fields = clazz.getDeclaredFields();
        for (JNIField field : fields) {
            JNIType type64;
            JNIType type;
            if (this.ignoreField(field)) continue;
            String conditional = field.getConditional();
            if (conditional != null) {
                this.outputln("#if " + conditional);
            }
            boolean allowConversion = !(type = field.getType()).equals(type64 = field.getType64());
            String simpleName = type.getSimpleName();
            String accessor = field.getAccessor();
            if (accessor == null || accessor.length() == 0) {
                accessor = field.getName();
            }
            if (type.isPrimitive()) {
                if (this.isCPP) {
                    this.output("\tenv->Set");
                } else {
                    this.output("\t(*env)->Set");
                }
                this.output(type.getTypeSignature1(allowConversion));
                if (this.isCPP) {
                    this.output("Field(lpObject, ");
                } else {
                    this.output("Field(env, lpObject, ");
                }
                this.output(field.getDeclaringClass().getSimpleName());
                this.output("Fc.");
                this.output(field.getName());
                this.output(", ");
                this.output("(" + type.getTypeSignature2(allowConversion) + ")");
                if (field.isPointer()) {
                    this.output("(intptr_t)");
                }
                this.output("lpStruct->" + accessor);
                this.output(");");
            } else if (type.isArray()) {
                JNIType componentType = type.getComponentType();
                JNIType componentType64 = type64.getComponentType();
                if (!componentType.isPrimitive()) throw new Error("not done");
                this.outputln("\t{");
                this.output("\t");
                this.output(type.getTypeSignature2(allowConversion));
                this.output(" lpObject1 = (");
                this.output(type.getTypeSignature2(allowConversion));
                if (this.isCPP) {
                    this.output(")env->GetObjectField(lpObject, ");
                } else {
                    this.output(")(*env)->GetObjectField(env, lpObject, ");
                }
                this.output(field.getDeclaringClass().getSimpleName());
                this.output("Fc.");
                this.output(field.getName());
                this.outputln(");");
                if (this.isCPP) {
                    this.output("\tenv->Set");
                } else {
                    this.output("\t(*env)->Set");
                }
                this.output(componentType.getTypeSignature1(!componentType.equals(componentType64)));
                if (this.isCPP) {
                    this.output("ArrayRegion(lpObject1, 0, sizeof(lpStruct->");
                } else {
                    this.output("ArrayRegion(env, lpObject1, 0, sizeof(lpStruct->");
                }
                this.output(accessor);
                this.output(")");
                if (!componentType.isType("byte")) {
                    this.output(" / sizeof(");
                    this.output(componentType.getTypeSignature2(!componentType.equals(componentType64)));
                    this.output(")");
                }
                this.output(", (");
                this.output(type.getTypeSignature4(allowConversion, false));
                this.output(")lpStruct->");
                this.output(accessor);
                this.outputln(");");
                this.output("\t}");
            } else {
                this.outputln("\t{");
                if (this.isCPP) {
                    this.output("\tjobject lpObject1 = env->GetObjectField(lpObject, ");
                } else {
                    this.output("\tjobject lpObject1 = (*env)->GetObjectField(env, lpObject, ");
                }
                this.output(field.getDeclaringClass().getSimpleName());
                this.output("Fc.");
                this.output(field.getName());
                this.outputln(");");
                this.output("\tif (lpObject1 != NULL) set");
                this.output(simpleName);
                this.output("Fields(env, lpObject1, &lpStruct->");
                this.output(accessor);
                this.outputln(");");
                this.output("\t}");
            }
            this.outputln();
            if (conditional == null) continue;
            this.outputln("#endif");
        }
    }

    void generateSetFunction(JNIClass clazz) {
        String clazzName = clazz.getNativeName();
        String simpleName = clazz.getSimpleName();
        this.output("void set");
        this.output(simpleName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        if (clazz.getFlag(ClassFlag.STRUCT) && !clazz.getFlag(ClassFlag.TYPEDEF)) {
            this.output("struct ");
        }
        this.output(clazzName);
        this.outputln(" *lpStruct)");
        this.outputln("{");
        this.output("\tif (!");
        this.output(simpleName);
        this.output("Fc.cached) cache");
        this.output(simpleName);
        this.outputln("Fields(env, lpObject);");
        this.generateSetFields(clazz);
        this.outputln("}");
    }

    void generateFunctions(JNIClass clazz) {
        this.generateCacheFunction(clazz);
        this.outputln();
        this.generateGetFunction(clazz);
        this.outputln();
        this.generateSetFunction(clazz);
    }

    boolean ignoreField(JNIField field) {
        int mods = field.getModifiers();
        return field.ignore() || (mods & 0x10) != 0 || (mods & 8) != 0;
    }
}

