/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.fusesource.hawtjni.runtime.Library;

public class PackageJarMojo
extends AbstractMojo {
    protected MavenProject project;
    private String name;
    private ArchiverManager archiverManager;
    private MavenProjectHelper projectHelper;
    private File libDirectory;
    private String platform;
    private List<String> osgiPlatforms;

    public void execute() throws MojoExecutionException {
        try {
            Library library = new Library(this.name);
            if (this.platform == null || this.platform.trim().length() == 0) {
                this.platform = library.getPlatform();
            }
            String packageName = this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + this.platform;
            JarArchiver archiver = (JarArchiver)this.archiverManager.getArchiver("jar");
            File packageFile = new File(new File(this.project.getBuild().getDirectory()), packageName + ".jar");
            archiver.setDestFile(packageFile);
            archiver.setIncludeEmptyDirs(true);
            archiver.addDirectory(this.libDirectory);
            Manifest manifest = new Manifest();
            manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-SymbolicName", this.project.getArtifactId() + "-" + this.platform));
            manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-Name", this.name + " for " + this.platform));
            manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-NativeCode", this.getNativeCodeValue(library)));
            manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-Version", this.project.getVersion()));
            manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-ManifestVersion", "2"));
            manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-Description", this.project.getDescription()));
            archiver.addConfiguredManifest(manifest);
            archiver.createArchive();
            this.projectHelper.attachArtifact(this.project, "jar", this.platform, packageFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("packageing failed: " + e, e);
        }
    }

    public String getNativeCodeValue(Library library) {
        if (this.osgiPlatforms == null || this.osgiPlatforms.isEmpty()) {
            return library.getPlatformSpecifcResourcePath(this.platform) + ";" + "osname=" + this.getOsgiOSName() + ";processor=" + this.getOsgiProcessor() + ",*";
        }
        boolean first = true;
        String rc = "";
        for (String s : this.osgiPlatforms) {
            if (!first) {
                rc = rc + ",";
            }
            first = false;
            if ("*".equals(s)) {
                rc = rc + s;
                continue;
            }
            rc = rc + library.getPlatformSpecifcResourcePath(this.platform) + ";" + s;
        }
        return rc;
    }

    public String getOsgiOSName() {
        String name = System.getProperty("os.name");
        String trimmed = name.toLowerCase().trim();
        if (trimmed.startsWith("win")) {
            return "Win32";
        }
        if (trimmed.startsWith("linux")) {
            return "Linux";
        }
        if (trimmed.startsWith("macos") || trimmed.startsWith("mac os")) {
            return "MacOS";
        }
        if (trimmed.startsWith("aix")) {
            return "AIX";
        }
        if (trimmed.startsWith("hpux")) {
            return "HPUX";
        }
        if (trimmed.startsWith("irix")) {
            return "IRIX";
        }
        if (trimmed.startsWith("netware")) {
            return "Netware";
        }
        if (trimmed.startsWith("openbsd")) {
            return "OpenBSD";
        }
        if (trimmed.startsWith("netbsd")) {
            return "NetBSD";
        }
        if (trimmed.startsWith("os2") || trimmed.startsWith("os/2")) {
            return "OS2";
        }
        if (trimmed.startsWith("qnx") || trimmed.startsWith("procnto")) {
            return "QNX";
        }
        if (trimmed.startsWith("solaris")) {
            return "Solaris";
        }
        if (trimmed.startsWith("sunos")) {
            return "SunOS";
        }
        if (trimmed.startsWith("vxworks")) {
            return "VxWorks";
        }
        return name;
    }

    public String getOsgiProcessor() {
        String name = System.getProperty("os.arch");
        String trimmed = name.toLowerCase().trim();
        if (trimmed.startsWith("x86-64") || trimmed.startsWith("amd64") || trimmed.startsWith("em64") || trimmed.startsWith("x86_64")) {
            return "x86-64";
        }
        if (trimmed.startsWith("x86") || trimmed.startsWith("pentium") || trimmed.startsWith("i386") || trimmed.startsWith("i486") || trimmed.startsWith("i586") || trimmed.startsWith("i686")) {
            return "x86";
        }
        if (trimmed.startsWith("68k")) {
            return "68k";
        }
        if (trimmed.startsWith("arm")) {
            return "ARM";
        }
        if (trimmed.startsWith("alpha")) {
            return "Alpha";
        }
        if (trimmed.startsWith("ignite") || trimmed.startsWith("psc1k")) {
            return "Ignite";
        }
        if (trimmed.startsWith("mips")) {
            return "Mips";
        }
        if (trimmed.startsWith("parisc")) {
            return "PArisc";
        }
        if (trimmed.startsWith("powerpc") || trimmed.startsWith("power") || trimmed.startsWith("ppc")) {
            return "PowerPC";
        }
        if (trimmed.startsWith("sparc")) {
            return "Sparc";
        }
        return name;
    }
}

