/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.avro;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.avro.specific.SpecificCompiler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class AvroMojo
extends AbstractMojo {
    protected MavenProject project;
    private File mainSourceDirectory;
    private File mainOutputDirectory;
    private File testSourceDirectory;
    private File testOutputDirectory;

    public void execute() throws MojoExecutionException {
        File[] mainFiles = null;
        if (this.mainSourceDirectory.exists()) {
            mainFiles = this.mainSourceDirectory.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    return name.endsWith(".avsc") || name.endsWith(".avpr");
                }
            });
            if (mainFiles == null || mainFiles.length == 0) {
                this.getLog().warn((CharSequence)("No avro files found in directory: " + this.mainSourceDirectory.getPath()));
            } else {
                this.processFiles(mainFiles, this.mainOutputDirectory);
                this.project.addCompileSourceRoot(this.mainOutputDirectory.getAbsolutePath());
            }
        }
        File[] testFiles = null;
        if (this.testSourceDirectory.exists()) {
            testFiles = this.testSourceDirectory.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    return name.endsWith(".avsc") || name.endsWith(".avpr");
                }
            });
            if (testFiles == null || testFiles.length == 0) {
                this.getLog().warn((CharSequence)("No avro files found in directory: " + this.testSourceDirectory.getPath()));
            } else {
                this.processFiles(testFiles, this.testOutputDirectory);
                this.project.addTestCompileSourceRoot(this.testOutputDirectory.getAbsolutePath());
            }
        }
    }

    private void processFiles(File[] mainFiles, File outputDir) throws MojoExecutionException {
        for (File file : mainFiles) {
            try {
                this.getLog().info((CharSequence)("Compiling: " + file.getPath()));
                if (file.getName().endsWith(".avpr")) {
                    SpecificCompiler.compileProtocol((File)file, (File)outputDir);
                    continue;
                }
                if (file.getName().endsWith(".avsc")) {
                    SpecificCompiler.compileSchema((File)file, (File)outputDir);
                    continue;
                }
                throw new RuntimeException("Unhandled file type: " + file.getName());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Avro compile failed.", (Exception)e);
            }
        }
    }
}

