/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.patch.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.patch.Patch;
import org.fusesource.patch.PatchException;
import org.fusesource.patch.Service;
import org.fusesource.patch.commands.PatchCommandSupport;

@Command(scope="patch", name="rollback", description="Rollback a patch installation")
public class Rollback
extends PatchCommandSupport {
    @Argument(name="PATCH", description="name of the patch to rollback")
    String patchId;

    @Override
    protected void doExecute(Service service) throws Exception {
        Patch patch = service.getPatch(this.patchId);
        if (patch == null) {
            throw new PatchException("Patch '" + this.patchId + "' not found");
        }
        if (!patch.isInstalled()) {
            throw new PatchException("Patch '" + this.patchId + "' is not installed");
        }
        patch.rollback(false);
    }
}

