/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.scalate.test.Config$;
import org.fusesource.scalate.test.JettyServer$;
import org.fusesource.scalate.util.IOUtil$;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.resource.Resource;
import org.mortbay.resource.ResourceCollection;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyServer
implements ScalaObject {
    private String webAppContext = "/";
    private String webAppDir;
    private int localPort = 0;
    private int port = 0;
    private Server server;
    private String overlayWebAppDir;
    private final String overlayProject;
    private String defaultDirectory = ".";
    private final String mavenWebAppSubDir;
    private final transient Log LOG = LogFactory.getLog(JettyServer.class);

    public JettyServer() {
        this.mavenWebAppSubDir = "src/main/webapp";
        this.overlayProject = "scalate-war";
        this.server = new Server();
    }

    private final String findOverlayModuleInParent$1(String dir) {
        while (true) {
            String parent;
            block6: {
                String string;
                block4: {
                    block5: {
                        block3: {
                            Option<File> temp1;
                            if (!((temp1 = this.exists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)dir).append((Object)"/").append((Object)this.overlayProject()).append((Object)"/").append((Object)this.mavenWebAppSubDir()).toString()}))) instanceof Some)) break block3;
                            Some temp2 = (Some)temp1;
                            File temp3 = (File)temp2.x();
                            string = temp3.getAbsolutePath();
                            break block4;
                        }
                        parent = new File(dir).getParent();
                        String string2 = parent;
                        if (string2 == null || string2.equals(null)) break block5;
                        String string3 = parent;
                        String string4 = dir;
                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block6;
                    }
                    string = null;
                }
                return string;
            }
            dir = parent;
        }
    }

    public Option<File> exists(Seq<String> names) {
        return ((IterableLike)names.map((Function1)new $anonfun$exists$1(this), Seq$.MODULE$.canBuildFrom())).find((Function1)new $anonfun$exists$2(this));
    }

    public String addFileSeparator(String path) {
        String string = path;
        return string == null || string.equals(null) || path.length() == 0 ? "" : new StringBuilder().append((Object)path).append((Object)"/").toString();
    }

    public String rootUrl() {
        return new StringBuilder().append((Object)"http://localhost:").append((Object)BoxesRunTime.boxToInteger((int)this.localPort())).append((Object)"/").toString();
    }

    /*
     * WARNING - void declaration
     */
    public String findOverlayModuleWebAppDir(String basedir) {
        String string;
        if (basedir.contains(this.overlayProject())) {
            string = null;
        } else {
            void var2_2;
            String answer = this.findOverlayModuleInParent$1(basedir);
            String string2 = answer;
            if (string2 == null || string2.equals(null)) {
                Package p = this.getClass().getPackage();
                Package package_ = p;
                if (package_ == null || package_.equals(null)) {
                    this.LOG().warn((Object)new StringBuilder().append((Object)"No package found for class: ").append((Object)this.getClass().getName()).toString());
                } else {
                    String string3;
                    String version = p.getSpecificationVersion();
                    String string4 = version;
                    if (string4 == null || string4.equals(null)) {
                        version = p.getImplementationVersion();
                    }
                    if ((string3 = version) == null || string3.equals(null)) {
                        this.LOG().warn((Object)new StringBuilder().append((Object)"No version available for ").append((Object)p).toString());
                    } else {
                        File war = new File(new StringBuilder().append((Object)System.getProperty("user.home", "~")).append((Object)"/.m2/repository/org/fusesource/scalate/scalate-war/").append((Object)version).append((Object)"/scalate-war-").append((Object)version).append((Object)".war").toString());
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Looking for war at ").append((Object)war.getAbsolutePath()).append((Object)" exists: ").append((Object)BoxesRunTime.boxToBoolean((boolean)war.exists())).toString());
                        if (war.exists()) {
                            answer = new StringBuilder().append((Object)basedir).append((Object)"/target/scalate-war-overlay").toString();
                            File warDir = new File(answer);
                            if (warDir.exists() && warDir.lastModified() <= war.lastModified()) {
                                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Removing old expanded war ").append((Object)warDir).toString());
                                IOUtil$.MODULE$.recursiveDelete(warDir, IOUtil$.MODULE$.recursiveDelete$default$2());
                            }
                            if (!warDir.exists()) {
                                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Unpacking ").append((Object)war).append((Object)" to ").append((Object)warDir).toString());
                                IOUtil$.MODULE$.unjar(warDir, (InputStream)new FileInputStream(war), (Function1)new $anonfun$findOverlayModuleWebAppDir$1(this));
                            }
                        } else {
                            this.LOG().warn((Object)new StringBuilder().append((Object)"No scalate war found in local repo at ").append((Object)war.getAbsolutePath()).toString());
                        }
                    }
                }
            }
            string = var2_2;
        }
        return string;
    }

    public void stop() {
        this.server().stop();
    }

    public void start() {
        String string;
        String basedir = this.addFileSeparator(Config$.MODULE$.baseDir());
        String defaultWebAppDir = new StringBuilder().append((Object)basedir).append((Object)this.mavenWebAppSubDir()).toString();
        this.LOG().info((Object)new StringBuilder().append((Object)"Using basedir: ").append((Object)basedir).toString());
        Object object = System.getProperty("scalate.workdir", "").length() == 0 ? System.setProperty("scalate.workdir", new StringBuilder().append((Object)basedir).append((Object)"target/scalate").toString()) : BoxedUnit.UNIT;
        this.LOG().info((Object)new StringBuilder().append((Object)"Starting Web Server on port: ").append((Object)BoxesRunTime.boxToInteger((int)this.port())).toString());
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port());
        connector.setServer(this.server());
        WebAppContext context = new WebAppContext();
        String string2 = this.webAppDir();
        if (string2 == null || string2.equals(null)) {
            File file = new File(defaultWebAppDir);
            if (file.exists()) {
                this.webAppDir_$eq(defaultWebAppDir);
            } else {
                this.webAppDir_$eq(new StringBuilder().append((Object)this.defaultDirectory()).append((Object)"/").append((Object)defaultWebAppDir).toString());
            }
        }
        if ((string = this.overlayWebAppDir()) == null || string.equals(null)) {
            this.overlayWebAppDir_$eq(this.findOverlayModuleWebAppDir(basedir));
        }
        this.LOG().info((Object)new StringBuilder().append((Object)"Defaulting the web app dir to: ").append((Object)this.webAppDir()).append((Object)" with overlayDir: ").append((Object)this.overlayWebAppDir()).toString());
        context.setContextPath(this.webAppContext());
        String string3 = this.overlayWebAppDir();
        if (string3 == null || string3.equals(null)) {
            context.setResourceBase(this.webAppDir());
        } else {
            context.setBaseResource((Resource)new ResourceCollection((String[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.webAppDir(), this.overlayWebAppDir()}), ClassManifest$.MODULE$.classType(String.class))));
        }
        context.setServer(this.server());
        this.server().setHandlers((Handler[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Handler[]{context}), ClassManifest$.MODULE$.classType(Handler.class)));
        this.server().setConnectors((Connector[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Connector[]{connector}), ClassManifest$.MODULE$.classType(Connector.class)));
        this.server().start();
        this.localPort_$eq(connector.getLocalPort());
        this.LOG().info((Object)"==============================================================================");
        this.LOG().info((Object)new StringBuilder().append((Object)"Started the Web Server: point your web browser at ").append((Object)this.rootUrl()).toString());
        this.LOG().info((Object)"==============================================================================");
    }

    public void webAppContext_$eq(String string) {
        this.webAppContext = string;
    }

    public String webAppContext() {
        return this.webAppContext;
    }

    public void webAppDir_$eq(String string) {
        this.webAppDir = string;
    }

    public String webAppDir() {
        return this.webAppDir;
    }

    public void localPort_$eq(int n) {
        this.localPort = n;
    }

    public int localPort() {
        return this.localPort;
    }

    public void port_$eq(int n) {
        this.port = n;
    }

    public int port() {
        return this.port;
    }

    public void server_$eq(Server server) {
        this.server = server;
    }

    public Server server() {
        return this.server;
    }

    public void overlayWebAppDir_$eq(String string) {
        this.overlayWebAppDir = string;
    }

    public String overlayWebAppDir() {
        return this.overlayWebAppDir;
    }

    public String overlayProject() {
        return this.overlayProject;
    }

    public void defaultDirectory_$eq(String string) {
        this.defaultDirectory = string;
    }

    public String defaultDirectory() {
        return this.defaultDirectory;
    }

    public String mavenWebAppSubDir() {
        return this.mavenWebAppSubDir;
    }

    private final Log LOG() {
        return this.LOG;
    }
}

