/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.naming;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.NamingException;
import org.gatein.naming.InitialContextFactory;

public class InitialContextFactoryBuilder
implements javax.naming.spi.InitialContextFactoryBuilder {
    private static final javax.naming.spi.InitialContextFactory DEFAULT_FACTORY = new InitialContextFactory();

    @Override
    public javax.naming.spi.InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) throws NamingException {
        String factoryClassName = (String)environment.get("java.naming.factory.initial");
        if (factoryClassName == null || InitialContextFactory.class.getName().equals(factoryClassName)) {
            return DEFAULT_FACTORY;
        }
        ClassLoader classLoader = this.getContextClassLoader();
        try {
            Class<?> factoryClass = Class.forName(factoryClassName, true, classLoader);
            return (javax.naming.spi.InitialContextFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new NamingException("Failed instantiate InitialContextFactory " + factoryClassName + " from classloader " + classLoader);
        }
    }

    private ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

