/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.naming;

import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import org.gatein.naming.util.FastCopyHashMap;
import org.jboss.threads.JBossThreadFactory;

public class NamingEventCoordinator {
    private volatile Map<TargetScope, List<ListenerHolder>> holdersByTarget = Collections.emptyMap();
    private volatile Map<NamingListener, ListenerHolder> holdersByListener = Collections.emptyMap();
    private final ThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("NamingEventCoordinator-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
    private final Executor executor = Executors.newSingleThreadExecutor(this.threadFactory);
    static final Integer[] DEFAULT_SCOPES = new Integer[]{0, 1, 2};

    synchronized void addListener(String target, int scope, NamingListener namingListener) {
        TargetScope targetScope = new TargetScope(target, scope);
        ListenerHolder holder = this.holdersByListener.get(namingListener);
        if (holder == null) {
            holder = new ListenerHolder(namingListener, targetScope);
            FastCopyHashMap<NamingListener, ListenerHolder> byListenerCopy = new FastCopyHashMap<NamingListener, ListenerHolder>(this.holdersByListener);
            byListenerCopy.put(namingListener, holder);
            this.holdersByListener = byListenerCopy;
        } else {
            holder.addTarget(targetScope);
        }
        List<ListenerHolder> holdersForTarget = this.holdersByTarget.get(targetScope);
        if (holdersForTarget == null) {
            holdersForTarget = new CopyOnWriteArrayList<ListenerHolder>();
            FastCopyHashMap<TargetScope, List<ListenerHolder>> byTargetCopy = new FastCopyHashMap<TargetScope, List<ListenerHolder>>(this.holdersByTarget);
            byTargetCopy.put(targetScope, holdersForTarget);
            this.holdersByTarget = byTargetCopy;
        }
        holdersForTarget.add(holder);
    }

    synchronized void removeListener(NamingListener namingListener) {
        ListenerHolder holder = this.holdersByListener.get(namingListener);
        if (holder == null) {
            return;
        }
        FastCopyHashMap<NamingListener, ListenerHolder> byListenerCopy = new FastCopyHashMap<NamingListener, ListenerHolder>(this.holdersByListener);
        byListenerCopy.remove(namingListener);
        this.holdersByListener = byListenerCopy;
        FastCopyHashMap<TargetScope, List<ListenerHolder>> byTargetCopy = new FastCopyHashMap<TargetScope, List<ListenerHolder>>(this.holdersByTarget);
        for (TargetScope targetScope : holder.targets) {
            List<ListenerHolder> holders = this.holdersByTarget.get(targetScope);
            holders.remove(holder);
            if (!holders.isEmpty()) continue;
            byTargetCopy.remove(targetScope);
        }
        this.holdersByTarget = byTargetCopy;
    }

    void fireEvent(EventContext context, Name name, Binding existingBinding, Binding newBinding, int type, String changeInfo, Integer ... scopes) {
        TargetScope targetScope;
        List<ListenerHolder> holders;
        String target = name.toString();
        HashSet<Integer> scopeSet = new HashSet<Integer>(Arrays.asList(scopes));
        NamingEvent event = new NamingEvent(context, type, newBinding, existingBinding, changeInfo);
        HashSet<ListenerHolder> holdersToFire = new HashSet<ListenerHolder>();
        if (scopeSet.contains(0) && (holders = this.holdersByTarget.get(targetScope = new TargetScope(target, 0))) != null) {
            for (ListenerHolder holder : holders) {
                holdersToFire.add(holder);
            }
        }
        if (scopeSet.contains(1) && !name.isEmpty() && (holders = this.holdersByTarget.get(targetScope = new TargetScope(name.getPrefix(name.size() - 1).toString(), 1))) != null) {
            for (ListenerHolder holder : holders) {
                holdersToFire.add(holder);
            }
        }
        if (scopeSet.contains(2) && !name.isEmpty()) {
            for (int i = 1; i < name.size(); ++i) {
                Name parentName = name.getPrefix(i);
                TargetScope targetScope2 = new TargetScope(parentName.toString(), 2);
                List<ListenerHolder> holders2 = this.holdersByTarget.get(targetScope2);
                if (holders2 == null) continue;
                for (ListenerHolder holder : holders2) {
                    holdersToFire.add(holder);
                }
            }
        }
        this.executor.execute(new FireEventTask(holdersToFire, event));
    }

    private class TargetScope {
        private final String target;
        private final int scope;

        private TargetScope(String target, int scope) {
            this.target = target;
            this.scope = scope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TargetScope that = (TargetScope)o;
            if (this.scope != that.scope) {
                return false;
            }
            return !(this.target != null ? !this.target.equals(that.target) : that.target != null);
        }

        public int hashCode() {
            int result = this.target != null ? this.target.hashCode() : 0;
            result = 31 * result + this.scope;
            return result;
        }
    }

    private class ListenerHolder {
        private volatile Set<TargetScope> targets = new HashSet<TargetScope>();
        private final NamingListener listener;

        private ListenerHolder(NamingListener listener, TargetScope initialTarget) {
            this.listener = listener;
            this.addTarget(initialTarget);
        }

        private synchronized void addTarget(TargetScope targetScope) {
            this.targets.add(targetScope);
        }
    }

    private class FireEventTask
    implements Runnable {
        private final Set<ListenerHolder> listenerHolders;
        private final NamingEvent event;

        private FireEventTask(Set<ListenerHolder> listenerHolders, NamingEvent event) {
            this.listenerHolders = listenerHolders;
            this.event = event;
        }

        @Override
        public void run() {
            for (ListenerHolder holder : this.listenerHolders) {
                NamingListener listener = holder.listener;
                switch (this.event.getType()) {
                    case 0: {
                        if (!(listener instanceof NamespaceChangeListener)) break;
                        ((NamespaceChangeListener)listener).objectAdded(this.event);
                        break;
                    }
                    case 1: {
                        if (!(listener instanceof NamespaceChangeListener)) break;
                        ((NamespaceChangeListener)listener).objectRemoved(this.event);
                        break;
                    }
                    case 2: {
                        if (!(listener instanceof NamespaceChangeListener)) break;
                        ((NamespaceChangeListener)listener).objectRenamed(this.event);
                        break;
                    }
                    case 3: {
                        if (!(listener instanceof ObjectChangeListener)) break;
                        ((ObjectChangeListener)listener).objectChanged(this.event);
                    }
                }
            }
        }
    }
}

