/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.naming.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class FastCopyHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final Object NULL = new Object();
    private static final long serialVersionUID = 10929568968762L;
    private static final int DEFAULT_CAPACITY = 8;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.67f;
    private transient Entry<K, V>[] table;
    private transient int size;
    private transient int threshold;
    private final float loadFactor;
    private transient int modCount;
    private transient KeySet keySet;
    private transient Values values;
    private transient EntrySet entrySet;

    public FastCopyHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Can not have a negative size table!");
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (!(loadFactor > 0.0f) || !(loadFactor <= 1.0f)) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and less than or equal to 1");
        }
        this.loadFactor = loadFactor;
        this.init(initialCapacity, loadFactor);
    }

    public FastCopyHashMap(Map<? extends K, ? extends V> map) {
        if (map instanceof FastCopyHashMap) {
            FastCopyHashMap fast = (FastCopyHashMap)map;
            this.table = (Entry[])fast.table.clone();
            this.loadFactor = fast.loadFactor;
            this.size = fast.size;
            this.threshold = fast.threshold;
        } else {
            this.loadFactor = 0.67f;
            this.init(map.size(), this.loadFactor);
            this.putAll(map);
        }
    }

    private void init(int initialCapacity, float loadFactor) {
        int c;
        for (c = 1; c < initialCapacity; c <<= 1) {
        }
        this.threshold = (int)((float)c * loadFactor);
        if (initialCapacity > this.threshold && c < 0x40000000) {
            this.threshold = (int)((float)(c <<= 1) * loadFactor);
        }
        this.table = new Entry[c];
    }

    public FastCopyHashMap(int initialCapacity) {
        this(initialCapacity, 0.67f);
    }

    public FastCopyHashMap() {
        this(8);
    }

    private static int hash(Object key) {
        int h = key.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static <K> K maskNull(K key) {
        return (K)(key == null ? NULL : key);
    }

    private static <K> K unmaskNull(K key) {
        return key == NULL ? null : (K)key;
    }

    private int nextIndex(int index, int length) {
        index = index >= length - 1 ? 0 : index + 1;
        return index;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private static int index(int hashCode, int length) {
        return hashCode & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        int index;
        key = FastCopyHashMap.maskNull(key);
        int hash = FastCopyHashMap.hash(key);
        int length = this.table.length;
        int start = index = FastCopyHashMap.index(hash, length);
        do {
            Entry<K, V> e;
            if ((e = this.table[index]) == null) {
                return null;
            }
            if (e.hash != hash || !FastCopyHashMap.eq(key, e.key)) continue;
            return e.value;
        } while ((index = this.nextIndex(index, length)) != start);
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        int index;
        key = FastCopyHashMap.maskNull(key);
        int hash = FastCopyHashMap.hash(key);
        int length = this.table.length;
        int start = index = FastCopyHashMap.index(hash, length);
        do {
            Entry<K, V> e;
            if ((e = this.table[index]) == null) {
                return false;
            }
            if (e.hash != hash || !FastCopyHashMap.eq(key, e.key)) continue;
            return true;
        } while ((index = this.nextIndex(index, length)) != start);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Entry<K, V> e : this.table) {
            if (e == null || !FastCopyHashMap.eq(value, e.value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        Entry<K, V> e;
        int index;
        key = FastCopyHashMap.maskNull(key);
        Entry<K, V>[] table = this.table;
        int hash = FastCopyHashMap.hash(key);
        int length = table.length;
        int start = index = FastCopyHashMap.index(hash, length);
        while ((e = table[index]) != null) {
            if (e.hash == hash && FastCopyHashMap.eq(key, e.key)) {
                table[index] = new Entry(e.key, e.hash, value);
                return e.value;
            }
            if ((index = this.nextIndex(index, length)) != start) continue;
            throw new IllegalStateException("Table is full!");
        }
        ++this.modCount;
        table[index] = new Entry<K, V>(key, hash, value);
        if (++this.size >= this.threshold) {
            this.resize(length);
        }
        return null;
    }

    private void resize(int from) {
        Entry<K, V>[] old;
        int newLength = from << 1;
        if (newLength > 0x40000000 || newLength <= from) {
            return;
        }
        Entry[] newTable = new Entry[newLength];
        for (Entry<K, V> e : old = this.table) {
            if (e == null) continue;
            int index = FastCopyHashMap.index(e.hash, newLength);
            while (newTable[index] != null) {
                index = this.nextIndex(index, newLength);
            }
            newTable[index] = e;
        }
        this.threshold = (int)(this.loadFactor * (float)newLength);
        this.table = newTable;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int size = map.size();
        if (size == 0) {
            return;
        }
        if (size > this.threshold) {
            int length;
            if (size > 0x40000000) {
                size = 0x40000000;
            }
            for (length = this.table.length; length < size; length <<= 1) {
            }
            this.resize(length);
        }
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        int start;
        key = FastCopyHashMap.maskNull(key);
        Entry<K, V>[] table = this.table;
        int length = table.length;
        int hash = FastCopyHashMap.hash(key);
        int index = start = FastCopyHashMap.index(hash, length);
        do {
            Entry<K, V> e;
            if ((e = table[index]) == null) {
                return null;
            }
            if (e.hash != hash || !FastCopyHashMap.eq(key, e.key)) continue;
            table[index] = null;
            this.relocate(index);
            ++this.modCount;
            --this.size;
            return e.value;
        } while ((index = this.nextIndex(index, length)) != start);
        return null;
    }

    private void relocate(int start) {
        Entry<K, V>[] table = this.table;
        int length = table.length;
        int current = this.nextIndex(start, length);
        Entry<K, V> e;
        while ((e = table[current]) != null) {
            int prefer = FastCopyHashMap.index(e.hash, length);
            if (current < prefer && (prefer <= start || start <= current) || prefer <= start && start <= current) {
                table[start] = e;
                table[current] = null;
                start = current;
            }
            current = this.nextIndex(current, length);
        }
        return;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry<K, V>[] table = this.table;
        for (int i = 0; i < table.length; ++i) {
            table[i] = null;
        }
        this.size = 0;
    }

    @Override
    public FastCopyHashMap<K, V> clone() {
        try {
            FastCopyHashMap clone = (FastCopyHashMap)super.clone();
            clone.table = (Entry[])this.table.clone();
            clone.entrySet = null;
            clone.values = null;
            clone.keySet = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void printDebugStats() {
        int optimal = 0;
        int total = 0;
        int totalSkew = 0;
        int maxSkew = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry<K, V> e = this.table[i];
            if (e == null) continue;
            ++total;
            int target = FastCopyHashMap.index(e.hash, this.table.length);
            if (i == target) {
                ++optimal;
                continue;
            }
            int skew = Math.abs(i - target);
            if (skew > maxSkew) {
                maxSkew = skew;
            }
            totalSkew += skew;
        }
        System.out.println(" Size:            " + this.size);
        System.out.println(" Real Size:       " + total);
        System.out.println(" Optimal:         " + optimal + " (" + (float)optimal * 100.0f / (float)total + "%)");
        System.out.println(" Average Distnce: " + (float)totalSkew / (float)(total - optimal));
        System.out.println(" Max Distance:    " + maxSkew);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.init(size, this.loadFactor);
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.putForCreate(key, value);
        }
        this.size = size;
    }

    private void putForCreate(K key, V value) {
        key = FastCopyHashMap.maskNull(key);
        Entry<K, V>[] table = this.table;
        int hash = FastCopyHashMap.hash(key);
        int length = table.length;
        int index = FastCopyHashMap.index(hash, length);
        Entry<K, V> e = table[index];
        while (e != null) {
            index = this.nextIndex(index, length);
            e = table[index];
        }
        table[index] = new Entry<K, V>(key, hash, value);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Entry<K, V> e : this.table) {
            if (e == null) continue;
            s.writeObject(FastCopyHashMap.unmaskNull(e.key));
            s.writeObject(e.value);
        }
    }

    protected static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        SimpleEntry(Map.Entry<K, V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return FastCopyHashMap.eq(this.key, e.getKey()) && FastCopyHashMap.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : FastCopyHashMap.hash(this.key)) ^ (this.value == null ? 0 : FastCopyHashMap.hash(this.value));
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = FastCopyHashMap.this.get(entry.getKey());
            return FastCopyHashMap.eq(entry.getValue(), value);
        }

        @Override
        public void clear() {
            FastCopyHashMap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return FastCopyHashMap.this.isEmpty();
        }

        @Override
        public int size() {
            return FastCopyHashMap.this.size();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public void clear() {
            FastCopyHashMap.this.clear();
        }

        @Override
        public int size() {
            return FastCopyHashMap.this.size();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public void clear() {
            FastCopyHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return FastCopyHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int size = this.size();
            FastCopyHashMap.this.remove(o);
            return this.size() < size;
        }

        @Override
        public int size() {
            return FastCopyHashMap.this.size();
        }
    }

    private class EntryIterator
    extends FasyCopyHashMapIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            Entry e = this.nextEntry();
            return new WriteThroughEntry(FastCopyHashMap.unmaskNull(e.key), e.value);
        }

        private class WriteThroughEntry
        extends SimpleEntry<K, V> {
            WriteThroughEntry(K key, V value) {
                super(key, value);
            }

            @Override
            public V setValue(V value) {
                if (EntryIterator.this.table != FastCopyHashMap.this.table) {
                    FastCopyHashMap.this.put(this.getKey(), value);
                }
                return super.setValue(value);
            }
        }
    }

    private class ValueIterator
    extends FasyCopyHashMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends FasyCopyHashMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return FastCopyHashMap.unmaskNull(this.nextEntry().key);
        }
    }

    private abstract class FasyCopyHashMapIterator<E>
    implements Iterator<E> {
        private int next = 0;
        private int expectedCount = FastCopyHashMap.access$300(FastCopyHashMap.this);
        private int current = -1;
        private boolean hasNext;
        Entry<K, V>[] table = FastCopyHashMap.access$400(FastCopyHashMap.this);

        private FasyCopyHashMapIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            Entry<K, V>[] table = this.table;
            for (int i = this.next; i < table.length; ++i) {
                if (table[i] == null) continue;
                this.next = i;
                this.hasNext = true;
                return true;
            }
            this.next = table.length;
            return false;
        }

        protected Entry<K, V> nextEntry() {
            if (FastCopyHashMap.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next++;
            this.hasNext = false;
            return this.table[this.current];
        }

        @Override
        public void remove() {
            Entry e;
            int current;
            if (FastCopyHashMap.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            int delete = current = this.current;
            if (current == -1) {
                throw new IllegalStateException();
            }
            this.current = -1;
            this.next = delete;
            Entry<K, V>[] table = this.table;
            if (table != FastCopyHashMap.this.table) {
                FastCopyHashMap.this.remove(table[delete].key);
                table[delete] = null;
                this.expectedCount = FastCopyHashMap.this.modCount;
                return;
            }
            int length = table.length;
            int i = delete;
            table[delete] = null;
            FastCopyHashMap.this.size--;
            while ((e = table[i = FastCopyHashMap.this.nextIndex(i, length)]) != null) {
                int prefer = FastCopyHashMap.index(e.hash, length);
                if ((i >= prefer || prefer > delete && delete > i) && (prefer > delete || delete > i)) continue;
                if (i < current && current <= delete && table == FastCopyHashMap.this.table) {
                    int remaining = length - current;
                    Entry[] newTable = new Entry[remaining];
                    System.arraycopy(table, current, newTable, 0, remaining);
                    this.table = newTable;
                    this.next = 0;
                }
                table[delete] = e;
                table[i] = null;
                delete = i;
            }
        }
    }

    private static final class Entry<K, V> {
        final K key;
        final int hash;
        final V value;

        Entry(K key, int hash, V value) {
            this.key = key;
            this.hash = hash;
            this.value = value;
        }
    }
}

