/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.api;

import java.io.Serializable;
import java.util.Locale;

public final class WindowState
implements Serializable {
    private static final long serialVersionUID = -6305311518934458562L;
    public static final WindowState NORMAL = new WindowState("normal");
    public static final WindowState MINIMIZED = new WindowState("minimized");
    public static final WindowState MAXIMIZED = new WindowState("maximized");
    private String name;

    private WindowState(String name) {
        this(name, false);
    }

    private WindowState(String name, boolean preserveCase) {
        if (name == null) {
            throw new IllegalArgumentException("Window state name cannot be null");
        }
        this.name = preserveCase ? name : name.toLowerCase(Locale.ENGLISH);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WindowState) {
            WindowState that = (WindowState)o;
            return this.name.equals(that.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    private Object readResolve() {
        WindowState standardWindowState = WindowState.isStandardWindowState(this.name);
        if (standardWindowState != null) {
            return standardWindowState;
        }
        return this;
    }

    private static WindowState isStandardWindowState(String name) {
        if (WindowState.NORMAL.name.equals(name)) {
            return NORMAL;
        }
        if (WindowState.MAXIMIZED.name.equals(name)) {
            return MAXIMIZED;
        }
        if (WindowState.MINIMIZED.name.equals(name)) {
            return MINIMIZED;
        }
        return null;
    }

    public static WindowState create(String name) {
        return WindowState.create(name, false);
    }

    public static WindowState create(String name, boolean preserveCase) {
        WindowState standardWindowState = WindowState.isStandardWindowState(name);
        if (standardWindowState != null) {
            return standardWindowState;
        }
        return new WindowState(name, preserveCase);
    }
}

