/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.api;

import java.io.Serializable;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletStateType;

public class StatefulPortletContext<S extends Serializable>
extends PortletContext {
    private final S state;
    private final PortletStateType<S> type;

    public static <S extends Serializable> StatefulPortletContext<S> create(String id, StatefulPortletContext<S> spc) {
        return new StatefulPortletContext<S>(id, spc.type, spc.state);
    }

    public static <S extends Serializable> StatefulPortletContext<S> create(String id, PortletStateType<S> type, S state) {
        return new StatefulPortletContext<S>(id, type, state);
    }

    StatefulPortletContext(String id, PortletStateType<S> type, S state) throws IllegalArgumentException {
        super(id);
        ParameterValidation.throwIllegalArgExceptionIfNull(type, (String)"Portlet type");
        ParameterValidation.throwIllegalArgExceptionIfNull(state, (String)"Portlet state");
        this.type = type;
        this.state = state;
    }

    public PortletStateType<S> getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulPortletContext that = (StatefulPortletContext)o;
        if (this.type.getJavaType().equals(that.type.getJavaType())) {
            Serializable thatState = (Serializable)this.type.getJavaType().cast(that.getState());
            return this.type.equals((Serializable)this.state, thatState);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        return result;
    }

    public S getState() {
        return this.state;
    }

    @Override
    public String toString() {
        return "StatefulPortletContext[" + this.id + "," + this.type.toString(this.state) + "]";
    }
}

