/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.io.Serialization;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.MarkupInfo;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.ClientContext;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.spi.PortalContext;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.RequestContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.ServerContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.pc.controller.PortletControllerContext;
import org.gatein.pc.controller.impl.ControllerPortletInvocationContext;
import org.gatein.pc.controller.state.PortletPageNavigationalState;
import org.gatein.pc.portlet.impl.spi.AbstractClientContext;
import org.gatein.pc.portlet.impl.spi.AbstractInstanceContext;
import org.gatein.pc.portlet.impl.spi.AbstractPortalContext;
import org.gatein.pc.portlet.impl.spi.AbstractRequestContext;
import org.gatein.pc.portlet.impl.spi.AbstractSecurityContext;
import org.gatein.pc.portlet.impl.spi.AbstractServerContext;
import org.gatein.pc.portlet.impl.spi.AbstractUserContext;
import org.gatein.pc.portlet.impl.spi.AbstractWindowContext;

public abstract class AbstractPortletControllerContext
implements PortletControllerContext {
    private static Logger log = LoggerFactory.getLogger(AbstractPortletControllerContext.class);
    public static final PortalContext PORTAL_CONTEXT = new AbstractPortalContext(Collections.singletonMap("javax.portlet.markup.head.element.support", "true"));
    public static final MarkupInfo MARKUP_INFO = new MarkupInfo(MediaType.TEXT_HTML, "UTF8");
    public static final int NAV_SCOPE = 0;
    public static final int SESSION_SCOPE = 1;
    private final HttpServletRequest req;
    private final HttpServletResponse resp;

    public AbstractPortletControllerContext(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.req = req;
        this.resp = resp;
    }

    public HttpServletRequest getClientRequest() {
        return this.req;
    }

    public HttpServletResponse getClientResponse() {
        return this.resp;
    }

    @Override
    public PortletInfo getPortletInfo(String windowId) {
        try {
            return this.getPortlet(windowId).getInfo();
        }
        catch (PortletInvokerException e) {
            log.error((Object)("Could not access portlet invoker for locating window " + windowId), (Throwable)e);
            return null;
        }
    }

    protected abstract Portlet getPortlet(String var1) throws PortletInvokerException;

    protected abstract PortletInvocationResponse invoke(PortletInvocation var1) throws PortletInvokerException;

    protected abstract Serialization<PortletPageNavigationalState> getPageNavigationalStateSerialization();

    @Override
    public PortletInvocationResponse invoke(ActionInvocation actionInvocation) throws PortletInvokerException {
        ControllerPortletInvocationContext context = (ControllerPortletInvocationContext)actionInvocation.getContext();
        String windowId = context.getWindowId();
        Portlet portlet = this.getPortlet(windowId);
        actionInvocation.setClientContext((ClientContext)new AbstractClientContext(this.req));
        actionInvocation.setServerContext((ServerContext)new AbstractServerContext(this.req, this.resp));
        actionInvocation.setInstanceContext((InstanceContext)new AbstractInstanceContext(portlet.getContext().getId()));
        actionInvocation.setUserContext((UserContext)new AbstractUserContext(this.req));
        actionInvocation.setWindowContext((WindowContext)new AbstractWindowContext(windowId));
        actionInvocation.setPortalContext(PORTAL_CONTEXT);
        actionInvocation.setSecurityContext((SecurityContext)new AbstractSecurityContext(this.req));
        actionInvocation.setRequestContext((RequestContext)new AbstractRequestContext(this.req));
        actionInvocation.setTarget(portlet.getContext());
        return this.invoke((PortletInvocation)actionInvocation);
    }

    @Override
    public PortletInvocationResponse invoke(List<Cookie> requestCookies, EventInvocation eventInvocation) throws PortletInvokerException {
        ControllerPortletInvocationContext context = (ControllerPortletInvocationContext)eventInvocation.getContext();
        String windowId = context.getWindowId();
        Portlet portlet = this.getPortlet(windowId);
        eventInvocation.setClientContext((ClientContext)new AbstractClientContext(this.req, requestCookies));
        eventInvocation.setServerContext((ServerContext)new AbstractServerContext(this.req, this.resp));
        eventInvocation.setInstanceContext((InstanceContext)new AbstractInstanceContext(portlet.getContext().getId()));
        eventInvocation.setUserContext((UserContext)new AbstractUserContext(this.req));
        eventInvocation.setWindowContext((WindowContext)new AbstractWindowContext(windowId));
        eventInvocation.setPortalContext(PORTAL_CONTEXT);
        eventInvocation.setSecurityContext((SecurityContext)new AbstractSecurityContext(this.req));
        eventInvocation.setTarget(portlet.getContext());
        return this.invoke((PortletInvocation)eventInvocation);
    }

    @Override
    public PortletInvocationResponse invoke(List<Cookie> requestCookies, RenderInvocation renderInvocation) throws PortletInvokerException {
        ControllerPortletInvocationContext context = (ControllerPortletInvocationContext)renderInvocation.getContext();
        String windowId = context.getWindowId();
        Portlet portlet = this.getPortlet(windowId);
        renderInvocation.setClientContext((ClientContext)new AbstractClientContext(this.req, requestCookies));
        renderInvocation.setServerContext((ServerContext)new AbstractServerContext(this.req, this.resp));
        renderInvocation.setInstanceContext((InstanceContext)new AbstractInstanceContext(portlet.getContext().getId()));
        renderInvocation.setUserContext((UserContext)new AbstractUserContext(this.req));
        renderInvocation.setWindowContext((WindowContext)new AbstractWindowContext(windowId));
        renderInvocation.setPortalContext(PORTAL_CONTEXT);
        renderInvocation.setSecurityContext((SecurityContext)new AbstractSecurityContext(this.req));
        renderInvocation.setTarget(portlet.getContext());
        return this.invoke((PortletInvocation)renderInvocation);
    }

    @Override
    public PortletInvocationResponse invoke(ResourceInvocation resourceInvocation) throws PortletInvokerException {
        ControllerPortletInvocationContext context = (ControllerPortletInvocationContext)resourceInvocation.getContext();
        String windowId = context.getWindowId();
        Portlet portlet = this.getPortlet(windowId);
        resourceInvocation.setClientContext((ClientContext)new AbstractClientContext(this.req));
        resourceInvocation.setServerContext((ServerContext)new AbstractServerContext(this.req, this.resp));
        resourceInvocation.setInstanceContext((InstanceContext)new AbstractInstanceContext(portlet.getContext().getId()));
        resourceInvocation.setUserContext((UserContext)new AbstractUserContext(this.req));
        resourceInvocation.setWindowContext((WindowContext)new AbstractWindowContext(windowId));
        resourceInvocation.setPortalContext(PORTAL_CONTEXT);
        resourceInvocation.setSecurityContext((SecurityContext)new AbstractSecurityContext(this.req));
        resourceInvocation.setRequestContext((RequestContext)new AbstractRequestContext(this.req));
        resourceInvocation.setTarget(portlet.getContext());
        return this.invoke((PortletInvocation)resourceInvocation);
    }

    @Override
    public PortletInvocationContext createPortletInvocationContext(String windowId, PortletPageNavigationalState pageNavigationalState) {
        return new ControllerPortletInvocationContext(this.getPageNavigationalStateSerialization(), this.req, this.resp, windowId, pageNavigationalState, MARKUP_INFO);
    }
}

