/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.management;

public class PortletInfo {
    private long renderRequestProcessingTime;
    private long actionRequestProcessingTime;
    private long maxActionTime;
    private long maxRenderTime;
    private String maxRenderRequestUri;
    private String maxActionRequestUri;
    private int actionRequestCount;
    private int renderRequestCount;
    private int renderErrorCount;
    private int actionErrorCount;

    public long getRenderRequestProcessingTime() {
        return this.renderRequestProcessingTime;
    }

    public long getActionRequestProcessingTime() {
        return this.actionRequestProcessingTime;
    }

    public long getMaxRenderTime() {
        return this.maxRenderTime;
    }

    public long getMaxActionTime() {
        return this.maxActionTime;
    }

    public String getMaxRenderRequestUri() {
        return this.maxRenderRequestUri;
    }

    public String getMaxActionRequestUri() {
        return this.maxActionRequestUri;
    }

    public synchronized float getAverageRenderTime() {
        return (float)this.renderRequestProcessingTime / (float)this.renderRequestCount;
    }

    public synchronized float getAverageActionTime() {
        return (float)this.actionRequestProcessingTime / (float)this.actionRequestCount;
    }

    public int getRenderRequestCount() {
        return this.renderRequestCount;
    }

    public int getActionRequestCount() {
        return this.actionRequestCount;
    }

    public int getRenderErrorCount() {
        return this.renderErrorCount;
    }

    public int getActionErrorCount() {
        return this.actionErrorCount;
    }

    public synchronized void newRenderCall(long time, boolean error) {
        this.renderRequestProcessingTime += time;
        if (time > this.maxRenderTime) {
            this.maxRenderTime = time;
        }
        ++this.renderRequestCount;
        if (error) {
            ++this.renderErrorCount;
        }
    }

    public synchronized void newActionCall(long time, boolean error) {
        this.actionRequestProcessingTime += time;
        if (time > this.maxActionTime) {
            this.maxActionTime = time;
        }
        ++this.actionRequestCount;
        if (error) {
            ++this.actionErrorCount;
        }
    }

    public boolean isUsed() {
        return this.getActionRequestCount() + this.getRenderRequestCount() > 0;
    }
}

