/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.mc;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gatein.common.io.IOTools;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.mc.PortletApplicationDeployment;
import org.gatein.pc.mc.metadata.factory.PortletApplicationModelFactory;
import org.gatein.pc.mc.metadata.impl.AnnotationPortletApplication10MetaData;
import org.gatein.pc.mc.metadata.impl.AnnotationPortletApplication20MetaData;
import org.gatein.pc.mc.metadata.impl.ValueTrimmingFilter;
import org.gatein.pc.portlet.container.ContainerPortletInvoker;
import org.gatein.pc.portlet.container.PortletContainer;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObject;
import org.gatein.pc.portlet.container.managed.ManagedObjectEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectLifeCycleEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventBroadcaster;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.managed.ManagedPortletApplication;
import org.gatein.pc.portlet.container.managed.PortletApplicationRegistry;
import org.gatein.pc.portlet.impl.container.PortletApplicationLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletContainerLifeCycle;
import org.gatein.pc.portlet.impl.metadata.PortletApplication10MetaData;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.resolver.MutableSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class PortletApplicationDeployer
implements WebAppListener,
PortletApplicationRegistry {
    private Logger log = LoggerFactory.getLogger(PortletApplicationDeployer.class);
    private PortletApplicationRegistry registry;
    private ServletContainer servletContainer;
    private ServletContainerFactory servletContainerFactory;
    private Map<String, PortletApplicationDeployment> deploymentMap = new HashMap<String, PortletApplicationDeployment>();
    private ClassLoader classLoader;
    private final Map<String, PortletApplicationLifeCycle> applications = new HashMap<String, PortletApplicationLifeCycle>();
    private ContainerPortletInvoker containerPortletInvoker;
    private ManagedObjectRegistryEventBroadcaster broadcaster;
    private final ManagedObjectRegistryEventListener bridgeToInvoker = new ManagedObjectRegistryEventListener(){

        public void onEvent(ManagedObjectRegistryEvent event) {
            ManagedObjectEvent managedObjectEvent;
            ManagedObject managedObject;
            if (event instanceof ManagedObjectEvent && (managedObject = (managedObjectEvent = (ManagedObjectEvent)event).getManagedObject()) instanceof PortletContainerLifeCycle) {
                PortletContainerLifeCycle portletContainerLifeCycle = (PortletContainerLifeCycle)managedObject;
                PortletContainer portletContainer = portletContainerLifeCycle.getPortletContainer();
                if (managedObjectEvent instanceof ManagedObjectLifeCycleEvent) {
                    ManagedObjectLifeCycleEvent lifeCycleEvent = (ManagedObjectLifeCycleEvent)managedObjectEvent;
                    LifeCycleStatus status = lifeCycleEvent.getStatus();
                    if (status == LifeCycleStatus.STARTED) {
                        PortletApplicationDeployer.this.containerPortletInvoker.addPortletContainer(portletContainer);
                    } else {
                        PortletApplicationDeployer.this.containerPortletInvoker.removePortletContainer(portletContainer);
                    }
                }
            }
        }
    };

    public PortletApplicationRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(PortletApplicationRegistry registry) {
        this.registry = registry;
    }

    public ServletContainer getServletContainer() {
        if (this.servletContainer == null) {
            this.servletContainer = this.servletContainerFactory.getServletContainer();
        }
        return this.servletContainer;
    }

    public void setServletContainer(ServletContainer servletContainer) {
        throw new UnsupportedOperationException("Inject ServletContainerFactory instead!");
    }

    public ServletContainerFactory getServletContainerFactory() {
        return this.servletContainerFactory;
    }

    public void setServletContainerFactory(ServletContainerFactory servletContainerFactory) {
        this.servletContainerFactory = servletContainerFactory;
    }

    public PortletInvoker getContainerPortletInvoker() {
        return this.containerPortletInvoker;
    }

    public void setContainerPortletInvoker(PortletInvoker containerPortletInvoker) {
        if (!(containerPortletInvoker instanceof ContainerPortletInvoker)) {
            if (containerPortletInvoker == null) {
                return;
            }
            throw new IllegalArgumentException("PortletApplicationDeployer can only accept ContainerPortletInvokers!");
        }
        this.containerPortletInvoker = (ContainerPortletInvoker)containerPortletInvoker;
    }

    public void onEvent(WebAppEvent event) {
        if (event instanceof WebAppLifeCycleEvent) {
            WebAppLifeCycleEvent lifeCycleEvent = (WebAppLifeCycleEvent)event;
            String cp = event.getWebApp().getContextPath();
            switch (lifeCycleEvent.getType()) {
                case 1: {
                    this.log.debug((Object)("Going to install war file" + cp));
                    this.add(event.getWebApp());
                    this.log.debug((Object)("Installed war file" + cp));
                    break;
                }
                case 0: {
                    try {
                        this.log.debug((Object)("Going to uninstall war file" + cp));
                        this.remove(event.getWebApp());
                        this.log.debug((Object)("Uninstalled war file" + cp));
                        break;
                    }
                    catch (Throwable e) {
                        this.log.error((Object)("Uninstalled war file " + cp + " with an error"), e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(WebApp webApp) {
        PortletApplication10MetaData metaData = this.buildPortletApplicationMetaData(webApp);
        if (metaData != null) {
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                PortletApplicationDeployment deployment = new PortletApplicationDeployment((ManagedObjectRegistryEventListener)this.broadcaster, webApp, metaData);
                this.deploymentMap.put(webApp.getContextPath(), deployment);
                deployment.install();
                PortletApplicationLifeCycle portletApplicationLifeCycle = deployment.getPortletApplicationLifeCycle();
                this.applications.put(portletApplicationLifeCycle.getId(), portletApplicationLifeCycle);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(WebApp webApp) {
        PortletApplicationDeployment deployment = this.deploymentMap.remove(webApp.getContextPath());
        if (deployment != null) {
            PortletApplicationLifeCycle portletApplicationLifeCycle = deployment.getPortletApplicationLifeCycle();
            this.applications.remove(portletApplicationLifeCycle.getId());
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                deployment.uninstall();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }

    public void start() {
        this.broadcaster = new ManagedObjectRegistryEventBroadcaster();
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.broadcaster.addListener(this.bridgeToInvoker);
        this.getServletContainer().addWebAppListener((WebAppListener)this);
    }

    public void stop() {
        this.getServletContainer().removeWebAppListener((WebAppListener)this);
        this.classLoader = null;
        this.broadcaster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortletApplication10MetaData buildPortletApplicationMetaData(WebApp webApp) {
        block6: {
            PortletApplication10MetaData portletApplication10MetaData;
            URL url = webApp.getServletContext().getResource("/WEB-INF/portlet.xml");
            if (url == null) break block6;
            BufferedInputStream in = null;
            try {
                PortletApplication10MetaData portletApplicationMD;
                in = IOTools.safeBufferedWrapper((InputStream)url.openStream());
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                unmarshaller.setNamespaceAware(true);
                unmarshaller.setSchemaValidation(false);
                unmarshaller.setValidation(false);
                PortletApplicationModelFactory factory = new PortletApplicationModelFactory();
                portletApplication10MetaData = portletApplicationMD = (PortletApplication10MetaData)unmarshaller.unmarshal((InputStream)in, (ObjectModelFactory)new ValueTrimmingFilter(factory), null);
            }
            catch (Throwable throwable) {
                try {
                    IOTools.safeClose((Closeable)in);
                    throw throwable;
                }
                catch (IOException e) {
                    this.log.error((Object)"Cannot read portlet.xml", (Throwable)e);
                    break block6;
                }
                catch (JBossXBException e) {
                    this.log.error((Object)"Cannot parse portlet.xml", (Throwable)e);
                }
            }
            IOTools.safeClose((Closeable)in);
            return portletApplication10MetaData;
        }
        return null;
    }

    public Collection<? extends ManagedPortletApplication> getManagedPortletApplications() {
        return this.applications.values();
    }

    public ManagedPortletApplication getManagedPortletApplication(String id) {
        return (ManagedPortletApplication)this.applications.get(id);
    }

    public void addListener(ManagedObjectRegistryEventListener listener) {
        this.broadcaster.addListener(listener);
    }

    public void removeListener(ManagedObjectRegistryEventListener listener) {
        this.broadcaster.addListener(listener);
    }

    static {
        try {
            SingletonSchemaResolverFactory factory = SingletonSchemaResolverFactory.getInstance();
            MutableSchemaResolver resolver = factory.getSchemaBindingResolver();
            resolver.mapSchemaLocation("http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd", "portlet-app_1_0.xsd");
            resolver.mapSchemaLocation("http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd", "portlet-app_2_0.xsd");
            resolver.mapLocationToClass("http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd", AnnotationPortletApplication20MetaData.class);
            resolver.mapLocationToClass("http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd", AnnotationPortletApplication10MetaData.class);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

