/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portal.jsp.taglib;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.gatein.common.util.Tools;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UnavailableResponse;
import org.gatein.pc.portal.jsp.PortalPrepareResponse;
import org.gatein.pc.portal.jsp.PortalRenderResponse;
import org.gatein.pc.portal.jsp.PortalResponse;
import org.gatein.pc.portal.jsp.WindowDef;
import org.gatein.pc.portal.jsp.WindowResult;
import org.gatein.pc.portal.jsp.taglib.JspWriterResponse;
import org.gatein.pc.portal.jsp.taglib.PageTag;
import org.gatein.pc.portal.jsp.taglib.PortalBodyTagSupport;

public class PortletTag
extends PortalBodyTagSupport {
    private static final Set<Mode> DEFAULT_MODES = Collections.unmodifiableSet(Tools.toSet((Object[])new Mode[]{Mode.VIEW, Mode.EDIT, Mode.HELP}));
    private static final Set<WindowState> DEFAULT_WINDOW_STATES = Collections.unmodifiableSet(Tools.toSet((Object[])new WindowState[]{WindowState.NORMAL, WindowState.MAXIMIZED, WindowState.MINIMIZED}));
    private String nameAttr;
    private String applicationNameAttr;
    private String supportedWindowStatesAttr;
    private String supportedModesAttr;
    private String initialModeAttr;
    private String errorPageAttr;
    private Set<WindowState> supportedWindowStates;
    private Set<Mode> supportedModes;
    private Mode initialMode;
    private PageTag pageTag;
    private String windowId;
    WindowResult result;

    public String getName() {
        return this.nameAttr;
    }

    public void setName(String name) {
        this.nameAttr = name;
    }

    public String getApplicationName() {
        return this.applicationNameAttr;
    }

    public void setApplicationName(String applicationName) {
        this.applicationNameAttr = applicationName;
    }

    public String getSupportedWindowStates() {
        return this.supportedWindowStatesAttr;
    }

    public void setSupportedWindowStates(String supportedWindowStates) {
        this.supportedWindowStatesAttr = supportedWindowStates;
    }

    public String getSupportedModes() {
        return this.supportedModesAttr;
    }

    public void setSupportedModes(String supportedModes) {
        this.supportedModesAttr = supportedModes;
    }

    public String getInitialMode() {
        return this.initialModeAttr;
    }

    public void setInitialMode(String initialMode) {
        this.initialModeAttr = initialMode;
    }

    public String getErrorPage() {
        return this.errorPageAttr;
    }

    public void setErrorPage(String errorPage) {
        this.errorPageAttr = errorPage;
    }

    private void initState(PortalResponse portalResponse) {
        Set<Object> supportedModes = new LinkedHashSet();
        if (this.supportedModesAttr != null) {
            for (String supportedModeValue : this.supportedModesAttr.split(",")) {
                Mode mode = Mode.create((String)supportedModeValue.trim());
                supportedModes.add(mode);
            }
        } else {
            supportedModes = DEFAULT_MODES;
        }
        Set<Object> supportedWindowStates = new LinkedHashSet();
        if (this.supportedWindowStatesAttr != null) {
            for (String supportedWindowStateValue : this.supportedWindowStatesAttr.split(",")) {
                WindowState windowState = WindowState.create((String)supportedWindowStateValue.trim());
                supportedWindowStates.add(windowState);
            }
        } else {
            supportedWindowStates = DEFAULT_WINDOW_STATES;
        }
        Mode initialMode = Mode.VIEW;
        if (this.initialModeAttr != null) {
            initialMode = Mode.create((String)this.initialModeAttr.trim());
        }
        String windowId = portalResponse.nextId();
        this.initialMode = initialMode;
        this.supportedModes = supportedModes;
        this.supportedWindowStates = supportedWindowStates;
        this.pageTag = (PageTag)PortletTag.findAncestorWithClass((Tag)this, PageTag.class);
        this.windowId = windowId;
    }

    private void destroyState() {
        this.initialMode = null;
        this.supportedModes = null;
        this.supportedWindowStates = null;
        this.pageTag = null;
        this.windowId = null;
    }

    public int doStartTag(PortalPrepareResponse prepareResponse) throws JspException {
        this.initState(prepareResponse);
        WindowDef windowDef = new WindowDef(this.nameAttr, this.applicationNameAttr, this.windowId, this.initialMode, this.supportedModes, this.supportedWindowStates);
        prepareResponse.addWindowDef(this.windowId, windowDef);
        return 0;
    }

    public int doEndTag(PortalPrepareResponse prepareResponse) throws JspException {
        this.destroyState();
        return 6;
    }

    public int doStartTag(PortalRenderResponse renderResponse) throws JspException {
        this.initState(renderResponse);
        WindowResult result = renderResponse.getWindowResult(this.windowId);
        if (result == null || result.getResponse() == null) {
            this.handleError(renderResponse, "not_found", null, null);
            return 0;
        }
        if (this.pageTag.maximizedId != null) {
            if (this.windowId.equals(this.pageTag.maximizedId)) {
                return this.render(renderResponse, result, 2);
            }
            return 0;
        }
        return this.render(renderResponse, result, 1);
    }

    public int doEndTag(PortalRenderResponse renderResponse) throws JspException {
        if (this.bodyContent != null) {
            this.pageTag.content = this.bodyContent.getString();
        }
        this.destroyState();
        return 6;
    }

    public int render(PortalRenderResponse renderResponse, WindowResult result, int rt) {
        PortletInvocationResponse portletResponse = result.getResponse();
        if (portletResponse instanceof ContentResponse) {
            this.result = result;
            return rt;
        }
        if (portletResponse instanceof ErrorResponse) {
            ErrorResponse error = (ErrorResponse)portletResponse;
            this.handleError(renderResponse, "portlet_error", error.getCause(), error.getMessage());
            return 0;
        }
        if (portletResponse instanceof UnavailableResponse) {
            this.handleError(renderResponse, "unavailable", null, null);
            return 0;
        }
        this.handleError(renderResponse, "internal_error", null, null);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(PortalRenderResponse renderResponse, String errorStatus, Throwable cause, String message) {
        RequestDispatcher rd;
        if (this.errorPageAttr != null && (rd = this.pageContext.getServletContext().getRequestDispatcher(this.errorPageAttr)) != null) {
            ServletRequest request = this.pageContext.getRequest();
            try {
                this.pageTag.status = PageTag.Status.SUSPENDED;
                request.setAttribute("org.gatein.pc.portal.error.status", (Object)errorStatus);
                request.setAttribute("org.gatein.pc.portal.error.cause", (Object)cause);
                request.setAttribute("org.gatein.pc.portal.error.message", (Object)message);
                request.setAttribute("org.gatein.pc.portal.error.window_id", (Object)this.windowId);
                request.setAttribute("org.gatein.pc.portal.error.application_name", (Object)this.applicationNameAttr);
                request.setAttribute("org.gatein.pc.portal.error.portlet_name", (Object)this.nameAttr);
                rd.include(this.pageContext.getRequest(), (ServletResponse)new JspWriterResponse(renderResponse, this.pageContext.getOut()));
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.pageTag.status = PageTag.Status.ACTIVE;
                request.removeAttribute("org.gatein.pc.portal.error.status");
                request.removeAttribute("org.gatein.pc.portal.error.cause");
                request.removeAttribute("org.gatein.pc.portal.error.message");
                request.removeAttribute("org.gatein.pc.portal.error.window_id");
                request.removeAttribute("org.gatein.pc.portal.error.application_name");
                request.removeAttribute("org.gatein.pc.portal.error.portlet_name");
            }
        }
    }
}

