/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portal;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ErrorHandlingFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(ErrorHandlingFilter.class);

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            this.log.error((Object)("Error during portal processing: " + e.getMessage()), e.getCause());
            if ("portlet_error".equals(e.getMessage())) {
                response.sendError(500);
            }
            if ("unavailable".equals(e.getMessage())) {
                response.sendError(503);
            }
            if ("internal_error".equals(e.getMessage())) {
                response.sendError(500);
            }
            if ("not_found".equals(e.getMessage())) {
                response.sendError(404);
            }
            throw e;
        }
    }

    public void destroy() {
    }
}

