/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portal.admin.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.portal.jsp.EventAcknowledgement;
import org.gatein.pc.portal.jsp.EventRoute;
import org.gatein.pc.portal.jsp.PageEventControllerContext;
import org.gatein.pc.portal.jsp.PagePortletControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggerPortlet
extends GenericPortlet {
    protected void doView(RenderRequest req, RenderResponse resp) throws PortletException, IOException {
        PagePortletControllerContext context = (PagePortletControllerContext)((Object)req.getAttribute("bilto"));
        PageEventControllerContext eventCC = null;
        if (context != null) {
            eventCC = context.getEventControllerContext();
        }
        PrintWriter writer = resp.getWriter();
        if (eventCC != null) {
            writer.print("<a href=\"javascript:showAllDetails()\" >Show All Details</a><br/><div class=\"debug-container\">");
            for (EventRoute route : eventCC.getRoots()) {
                int id = DebuggerPortlet.rand(1, 1000);
                writer.println("<div class=\"event\" id=\"event-" + id + "\">\n");
                this.printRoute(route, writer, context, id, "");
                writer.println("</div>\n");
            }
            writer.println("</div>\n");
        } else {
            writer.println("No event phase happened in the last request");
        }
    }

    private void printRoute(EventRoute route, PrintWriter writer, PagePortletControllerContext context, int id, String cid) {
        writer.print("<div onmouseover=\"showDetails(this,'details-" + id + cid + "')\" onmouseout=\"hideDetails(this,'details-" + id + cid + "')\" onclick=\"new Effect.Highlight('" + context.getPortletInfo(route.getSource()).getName() + "', {startcolor:'#990000', endcolor:'ffffdd',queue: {position:'start', scope: 'highlight', limit:2}});new Effect.Highlight('" + context.getPortletInfo(route.getDestination()).getName() + "', {startcolor:'#990000', endcolor:'ffffdd',queue: {position:'end', scope: 'highlight', limit:2}});\" >" + "<div class=\"event-header\">\n" + "         <h4>" + context.getPortletInfo(route.getSource()).getName() + "</h4>\n" + "         <div>Event: " + route.getName().getLocalPart() + "</div>\n" + "       </div>\n");
        writer.print("<div class=\"event-body\"><p><label>Source: </label>" + context.getPortletInfo(route.getSource()).getName() + "<img src=\"/simple-portal/images/debug/arrow.gif\" alt=\"\"/>");
        writer.print("<label>Destination: </label>" + context.getPortletInfo(route.getDestination()).getName() + "</p>\n" + "  <div class=\"details\" id=\"details-" + id + cid + "\">\n" + "      <div class=\"details-frame\">\n" + "         " + this.formatAck(route.getAcknowledgement()) + "\n" + "         <div class=\"dotted-white\"></div>\n" + "         <label>Payload: " + route.getPayload() + "</label>\n" + "      </div>\n" + "   </div></div>" + "");
        writer.print("</div>");
        for (EventRoute child : route.getChildren()) {
            id = DebuggerPortlet.rand(1, 1000);
            writer.println("<div class=\"children\">");
            this.printRoute(child, writer, context, id, "a");
            writer.println("</div>");
        }
    }

    private String formatAck(EventAcknowledgement ack) {
        if (ack instanceof EventAcknowledgement.Consumed) {
            EventAcknowledgement.Consumed consumedAck = (EventAcknowledgement.Consumed)ack;
            PortletInvocationResponse response = consumedAck.getResponse();
            if (response instanceof UpdateNavigationalStateResponse) {
                StringBuilder sb;
                Map publicChanges;
                ParametersStateString newNS;
                UpdateNavigationalStateResponse updateResponse = (UpdateNavigationalStateResponse)response;
                String[] strings = new String[4];
                if (updateResponse.getMode() != null) {
                    strings[0] = "mode=" + updateResponse.getMode();
                }
                if (updateResponse.getWindowState() != null) {
                    strings[1] = "windowstate=" + updateResponse.getWindowState();
                }
                if ((newNS = (ParametersStateString)updateResponse.getNavigationalState()) != null) {
                    StringBuilder sb2 = new StringBuilder();
                    sb2.append("private=");
                    this.formatMap(newNS.getParameters(), sb2);
                    strings[2] = sb2.toString();
                }
                if ((publicChanges = updateResponse.getPublicNavigationalStateUpdates()) != null) {
                    sb = new StringBuilder();
                    sb.append("public=");
                    this.formatMap(publicChanges, sb);
                    strings[3] = sb.toString();
                }
                sb = new StringBuilder("[");
                this.formatList(strings, sb);
                sb.append("]");
                return sb.toString();
            }
            if (response instanceof ErrorResponse) {
                ErrorResponse errorResponse = (ErrorResponse)response;
                return "Error:" + errorResponse.getMessage();
            }
            return "Todo format:" + response;
        }
        return ack.toString();
    }

    private void formatList(String[] strings, StringBuilder sb) {
        boolean done = false;
        for (String string : strings) {
            if (string == null) continue;
            sb.append(done ? "," : "").append(string);
            done = true;
        }
    }

    private void formatMap(Map<String, String[]> map, StringBuilder sb) {
        sb.append("{");
        Iterator<Map.Entry<String, String[]>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String[]> entry = i.next();
            sb.append(entry.getKey());
            sb.append("=(");
            String[] value = entry.getValue();
            this.formatList(entry.getValue(), sb);
            sb.append(')');
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        sb.append("}");
    }

    public static int rand(int lo, int hi) {
        Random rn2 = new Random();
        int n = hi - lo + 1;
        int i = rn2.nextInt() % n;
        if (i < 0) {
            i = -i;
        }
        return lo + i;
    }
}

