/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portal.jsp;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.io.IOTools;
import org.gatein.common.io.Serialization;
import org.gatein.common.io.SerializationFilter;
import org.gatein.common.util.Base64;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UnavailableResponse;
import org.gatein.pc.controller.PortletController;
import org.gatein.pc.controller.PortletControllerContext;
import org.gatein.pc.controller.impl.ControllerRequestFactory;
import org.gatein.pc.controller.impl.PortletURLRenderer;
import org.gatein.pc.controller.request.ControllerRequest;
import org.gatein.pc.controller.request.PortletActionRequest;
import org.gatein.pc.controller.response.ControllerResponse;
import org.gatein.pc.controller.response.PageUpdateResponse;
import org.gatein.pc.controller.response.PortletResponse;
import org.gatein.pc.controller.response.ResourceResponse;
import org.gatein.pc.controller.state.PortletPageNavigationalState;
import org.gatein.pc.controller.state.PortletPageNavigationalStateSerialization;
import org.gatein.pc.portal.jsp.PagePortletControllerContext;
import org.gatein.pc.portal.jsp.PortalPrepareResponse;
import org.gatein.pc.portal.jsp.PortalRenderResponse;
import org.gatein.wci.util.RequestDecoder;

public class ControllerFilter
implements Filter {
    private FilterConfig config;
    private boolean redirectAfterAction = false;

    private ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        try {
            this.doFilter((HttpServletRequest)req, (HttpServletResponse)resp, chain);
        }
        catch (PortletInvokerException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException, PortletInvokerException {
        PortletInvoker invoker = (PortletInvoker)this.getServletContext().getAttribute("jboss.portal:service=ConsumerPortletInvoker");
        PortalPrepareResponse prepareResponse = new PortalPrepareResponse(req, resp);
        chain.doFilter((ServletRequest)req, (ServletResponse)prepareResponse);
        PagePortletControllerContext context = new PagePortletControllerContext(req, resp, invoker, this.getServletContext(), prepareResponse);
        String type = req.getParameter("type");
        PortletPageNavigationalState pageNavigationalState = null;
        if ("portlet".equals(type)) {
            ControllerResponse controllerResponse;
            ControllerRequestFactory factory = new ControllerRequestFactory(context.getPageNavigationalStateSerialization());
            RequestDecoder decoder = new RequestDecoder(req);
            ControllerRequest request = factory.decode(decoder.getQueryParameters(), decoder.getBody());
            try {
                controllerResponse = new PortletController().process((PortletControllerContext)context, request);
            }
            catch (PortletInvokerException e) {
                throw new ServletException((Throwable)e);
            }
            if (controllerResponse instanceof PageUpdateResponse) {
                PageUpdateResponse pageUpdate = (PageUpdateResponse)controllerResponse;
                pageNavigationalState = pageUpdate.getPageNavigationalState();
                req.setAttribute("bilto", (Object)context);
                if (request instanceof PortletActionRequest && this.redirectAfterAction) {
                    PortletURLRenderer renderer = new PortletURLRenderer(pageUpdate.getPageNavigationalState(), context.getClientRequest(), context.getClientResponse(), context.getPageNavigationalStateSerialization());
                    String url = renderer.renderURL(new URLFormat(null, null, Boolean.valueOf(true), null));
                    resp.sendRedirect(url);
                    return;
                }
            } else {
                if (controllerResponse instanceof ResourceResponse) {
                    ResourceResponse resourceResponse = (ResourceResponse)controllerResponse;
                    PortletInvocationResponse pir = resourceResponse.getResponse();
                    if (pir instanceof ContentResponse) {
                        ContentResponse contentResponse = (ContentResponse)pir;
                        if (contentResponse.getType() == 0) {
                            resp.setStatus(204);
                        } else {
                            String contentType = contentResponse.getContentType();
                            if (contentType != null) {
                                resp.setContentType(contentType);
                            }
                            if (contentResponse.getType() == 2) {
                                ServletOutputStream out = null;
                                try {
                                    out = resp.getOutputStream();
                                    out.write(contentResponse.getBytes());
                                }
                                finally {
                                    IOTools.safeClose((Closeable)out);
                                }
                            }
                            PrintWriter writer = null;
                            try {
                                writer = resp.getWriter();
                                ((Writer)writer).write(contentResponse.getChars());
                            }
                            finally {
                                ((Writer)writer).close();
                            }
                        }
                    }
                    return;
                }
                if (controllerResponse instanceof PortletResponse) {
                    PortletResponse portletResponse = (PortletResponse)controllerResponse;
                    PortletInvocationResponse pir = portletResponse.getResponse();
                    if (pir instanceof ErrorResponse) {
                        ErrorResponse errorResponse = (ErrorResponse)pir;
                        if (errorResponse.getCause() != null) {
                            throw new ServletException("portlet_error", errorResponse.getCause());
                        }
                        throw new ServletException("portlet_error");
                    }
                    if (pir instanceof UnavailableResponse) {
                        throw new ServletException("unavailable");
                    }
                }
            }
        } else {
            PortletPageNavigationalStateSerialization serialization = new PortletPageNavigationalStateSerialization(context.getStateControllerContext());
            pageNavigationalState = null;
            String blah = req.getParameter("pagenavigationalstate");
            if (blah != null) {
                byte[] bytes = Base64.decode((String)blah, (Base64.EncodingOption)Base64.EncodingOption.USEURLSAFEENCODING);
                pageNavigationalState = (PortletPageNavigationalState)IOTools.unserialize((Serialization)serialization, (SerializationFilter)SerializationFilter.COMPRESSOR, (byte[])bytes);
            }
        }
        PortalRenderResponse renderResponse = new PortalRenderResponse(req, resp, context, pageNavigationalState, prepareResponse);
        chain.doFilter((ServletRequest)req, (ServletResponse)renderResponse);
    }

    public void destroy() {
        this.config = null;
    }
}

