/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portal.jsp;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.controller.event.EventControllerContext;
import org.gatein.pc.controller.event.EventPhaseContext;
import org.gatein.pc.controller.event.PortletWindowEvent;
import org.gatein.pc.portal.jsp.EventAcknowledgement;
import org.gatein.pc.portal.jsp.EventRoute;
import org.gatein.pc.portal.jsp.PagePortletControllerContext;
import org.gatein.pc.portal.jsp.PortalPrepareResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageEventControllerContext
implements EventControllerContext {
    private final PortalPrepareResponse prepareResponse;
    private final PagePortletControllerContext context;
    private final Map<PortletWindowEvent, EventRoute> routings;
    private final List<EventRoute> roots;

    public PageEventControllerContext(PagePortletControllerContext context, PortalPrepareResponse prepareResponse) {
        this.context = context;
        this.prepareResponse = prepareResponse;
        this.routings = new LinkedHashMap<PortletWindowEvent, EventRoute>();
        this.roots = new ArrayList<EventRoute>();
    }

    public List<EventRoute> getRoots() {
        return this.roots;
    }

    public void eventProduced(EventPhaseContext context, PortletWindowEvent producedEvent, PortletWindowEvent causeEvent) {
        EventRoute relatedRoute = this.routings.get(causeEvent);
        for (String windowId : this.prepareResponse.getWindowIds()) {
            try {
                PortletInfo portletInfo;
                Portlet portlet = this.context.getPortlet(windowId);
                if (portlet == null || !(portletInfo = portlet.getInfo()).getEventing().getConsumedEvents().containsKey(producedEvent.getName())) continue;
                PortletWindowEvent destinationEvent = new PortletWindowEvent(producedEvent.getName(), producedEvent.getPayload(), windowId);
                EventRoute eventRoute = new EventRoute(relatedRoute, producedEvent.getName(), producedEvent.getPayload(), producedEvent.getWindowId(), destinationEvent.getWindowId());
                if (relatedRoute != null) {
                    relatedRoute.children.add(eventRoute);
                } else {
                    this.roots.add(eventRoute);
                }
                this.routings.put(destinationEvent, eventRoute);
                context.queueEvent(destinationEvent);
            }
            catch (PortletInvokerException e) {
                e.printStackTrace();
                context.interrupt();
            }
        }
    }

    public void eventConsumed(EventPhaseContext context, PortletWindowEvent consumedEvent, PortletInvocationResponse consumerResponse) {
        EventRoute route = this.routings.get(consumedEvent);
        route.acknowledgement = new EventAcknowledgement.Consumed(consumerResponse);
    }

    public void eventFailed(EventPhaseContext context, PortletWindowEvent failedEvent, Throwable throwable) {
        EventRoute route = this.routings.get(failedEvent);
        route.acknowledgement = new EventAcknowledgement.Failed(throwable);
    }

    public void eventDiscarded(EventPhaseContext context, PortletWindowEvent discardedEvent, int cause) {
        EventRoute route = this.routings.get(discardedEvent);
        route.acknowledgement = new EventAcknowledgement.Discarded(cause);
    }
}

