/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portal.jsp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.io.Serialization;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.controller.PortletControllerContext;
import org.gatein.pc.controller.impl.AbstractPortletControllerContext;
import org.gatein.pc.controller.impl.state.StateControllerContextImpl;
import org.gatein.pc.controller.state.PortletPageNavigationalState;
import org.gatein.pc.controller.state.PortletPageNavigationalStateSerialization;
import org.gatein.pc.controller.state.StateControllerContext;
import org.gatein.pc.portal.jsp.PageEventControllerContext;
import org.gatein.pc.portal.jsp.PortalPrepareResponse;
import org.gatein.pc.portal.jsp.WindowDef;
import org.gatein.wci.IllegalRequestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagePortletControllerContext
extends AbstractPortletControllerContext {
    private final PageEventControllerContext eventControllerContext;
    private final StateControllerContext stateControllerContext;
    private final Serialization<PortletPageNavigationalState> serialization;
    private final PortalPrepareResponse prepareResponse;
    private final Map<Key, Portlet> portlets;
    private final PortletInvoker invoker;

    public PagePortletControllerContext(HttpServletRequest req, HttpServletResponse resp, PortletInvoker invoker, ServletContext servletContext, PortalPrepareResponse prepareResponse) throws IllegalRequestException, IOException, ServletException, PortletInvokerException {
        super(req, resp);
        HashMap<Key, Portlet> portlets = new HashMap<Key, Portlet>();
        for (Portlet portlet : invoker.getPortlets()) {
            PortletInfo portletInfo = portlet.getInfo();
            String portletName = portletInfo.getName();
            String applicationName = portletInfo.getApplicationName();
            Key key = new Key(applicationName, portletName);
            portlets.put(key, portlet);
        }
        this.invoker = invoker;
        this.portlets = portlets;
        this.prepareResponse = prepareResponse;
        this.stateControllerContext = new StateControllerContextImpl((PortletControllerContext)this);
        this.eventControllerContext = new PageEventControllerContext(this, prepareResponse);
        this.serialization = new PortletPageNavigationalStateSerialization(this.stateControllerContext);
    }

    public Portlet findPortlet(String applicationName, String portletName) {
        return this.portlets.get(new Key(applicationName, portletName));
    }

    protected Portlet getPortlet(String windowId) throws PortletInvokerException {
        WindowDef windowDef = this.prepareResponse.getWindowDef(windowId);
        return this.findPortlet(windowDef.getApplicationName(), windowDef.getPortletName());
    }

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        return this.invoker.invoke(invocation);
    }

    public PageEventControllerContext getEventControllerContext() {
        return this.eventControllerContext;
    }

    public StateControllerContext getStateControllerContext() {
        return this.stateControllerContext;
    }

    public Serialization<PortletPageNavigationalState> getPageNavigationalStateSerialization() {
        return this.serialization;
    }

    private static class Key {
        private final String applicationName;
        private final String portletName;

        private Key(String applicationName, String portletName) {
            this.applicationName = applicationName;
            this.portletName = portletName;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Key) {
                Key that = (Key)obj;
                return this.applicationName.equals(that.applicationName) && this.portletName.equals(that.portletName);
            }
            return false;
        }

        public int hashCode() {
            return this.applicationName.hashCode() + this.portletName.hashCode();
        }
    }
}

