/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portal.jsp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.controller.PortletController;
import org.gatein.pc.controller.PortletControllerContext;
import org.gatein.pc.controller.state.PortletPageNavigationalState;
import org.gatein.pc.controller.state.PortletWindowNavigationalState;
import org.gatein.pc.portal.jsp.PageParameterDef;
import org.gatein.pc.portal.jsp.PagePortletControllerContext;
import org.gatein.pc.portal.jsp.PortalPrepareResponse;
import org.gatein.pc.portal.jsp.PortalResponse;
import org.gatein.pc.portal.jsp.WindowDef;
import org.gatein.pc.portal.jsp.WindowResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalRenderResponse
extends PortalResponse {
    private PortletPageNavigationalState pageNavigationalState;
    private PagePortletControllerContext portletControllerContext;
    private Map<String, WindowResult> windowResults;

    public PortalRenderResponse(HttpServletRequest request, HttpServletResponse response, PagePortletControllerContext portletControllerContext, PortletPageNavigationalState pageNavigationalState, PortalPrepareResponse prepareResponse) throws PortletInvokerException {
        super(request, response);
        Set<QName> pageParameterNames = prepareResponse.getPageParameterNames();
        if (pageParameterNames.size() > 0) {
            if (pageNavigationalState == null) {
                pageNavigationalState = portletControllerContext.getStateControllerContext().createPortletPageNavigationalState(true);
            }
            for (QName parameterName : pageParameterNames) {
                PageParameterDef parameterDef = prepareResponse.getPageParameterDef(parameterName);
                boolean update = parameterDef.isFrozen() ? true : pageNavigationalState.getPublicNavigationalState(parameterName) == null;
                if (!update) continue;
                pageNavigationalState.setPublicNavigationalState(parameterName, new String[]{parameterDef.getValue()});
            }
        }
        this.portletControllerContext = portletControllerContext;
        this.windowResults = new HashMap<String, WindowResult>();
        this.pageNavigationalState = pageNavigationalState;
        this.render(prepareResponse);
    }

    public PortletPageNavigationalState getPageNavigationalState() {
        return this.pageNavigationalState;
    }

    public Set<String> getWindowIds() {
        return this.windowResults.keySet();
    }

    public WindowResult getWindowResult(String windowId) {
        return this.windowResults.get(windowId);
    }

    public PagePortletControllerContext getPortletControllerContext() {
        return this.portletControllerContext;
    }

    private PortletInvocationResponse render(List<Cookie> cookies, String windowId) throws PortletInvokerException {
        return new PortletController().render((PortletControllerContext)this.portletControllerContext, cookies, this.pageNavigationalState, windowId);
    }

    private void render(PortalPrepareResponse prepareResponse) {
        for (String windowId : prepareResponse.getWindowIds()) {
            WindowDef windowDef = prepareResponse.getWindowDef(windowId);
            try {
                Portlet portlet = this.portletControllerContext.getPortlet(windowId);
                if (portlet == null) continue;
                PortletInvocationResponse portletResponse = this.render(null, windowId);
                WindowResult result = new WindowResult(windowDef, portletResponse);
                this.windowResults.put(windowId, result);
            }
            catch (PortletInvokerException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isMaximizedWindow(String windowId) {
        if (windowId == null) {
            throw new IllegalArgumentException();
        }
        return windowId.equals(this.getMaximizedWindowId());
    }

    public String getMaximizedWindowId() {
        if (this.pageNavigationalState != null) {
            for (String windowId : this.pageNavigationalState.getPortletWindowIds()) {
                PortletWindowNavigationalState windowNS = this.pageNavigationalState.getPortletWindowNavigationalState(windowId);
                if (!WindowState.MAXIMIZED.equals((Object)windowNS.getWindowState())) continue;
                return windowId;
            }
        }
        return null;
    }
}

