/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.container;

import org.gatein.pc.portlet.container.ManagedObjectRegistryEventList;
import org.gatein.pc.portlet.container.ObjectSupport;
import org.gatein.pc.portlet.container.PortletApplicationContext;
import org.gatein.pc.portlet.container.PortletApplicationContextSupport;
import org.gatein.pc.portlet.container.PortletApplicationObjectSupport;
import org.gatein.pc.portlet.container.PortletContainerContext;
import org.gatein.pc.portlet.container.PortletContainerContextSupport;
import org.gatein.pc.portlet.container.PortletContainerObjectSupport;
import org.gatein.pc.portlet.container.PortletFilterContext;
import org.gatein.pc.portlet.container.PortletFilterContextSupport;
import org.gatein.pc.portlet.container.PortletFilterObjectSupport;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObject;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.object.PortletApplicationObject;
import org.gatein.pc.portlet.container.object.PortletContainerObject;
import org.gatein.pc.portlet.container.object.PortletFilterObject;
import org.gatein.pc.portlet.impl.container.PortletApplicationLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletContainerLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletFilterLifeCycle;
import org.jboss.unit.api.Assert;
import org.jboss.unit.api.pojo.annotations.Create;
import org.jboss.unit.api.pojo.annotations.Test;

@Test
public class LifeCycle1Test {
    ManagedObjectRegistryEventList events;
    PortletApplicationObjectSupport application;
    PortletApplicationLifeCycle applicationLC;
    PortletFilterObjectSupport filter;
    PortletContainerObjectSupport container;
    PortletFilterLifeCycle filterLC;
    PortletContainerLifeCycle containerLC;

    @Create
    public void create() {
        this.events = new ManagedObjectRegistryEventList();
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLC = new PortletApplicationLifeCycle((ManagedObjectRegistryEventListener)this.events, (PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.filter = new PortletFilterObjectSupport("filter2");
        this.container = new PortletContainerObjectSupport("container2");
        this.filterLC = this.applicationLC.addPortletFilter((PortletFilterContext)new PortletFilterContextSupport(), (PortletFilterObject)this.filter);
        this.containerLC = this.applicationLC.addPortletContainer((PortletContainerContext)new PortletContainerContextSupport(), (PortletContainerObject)this.container);
        this.applicationLC.addDependency(this.filterLC, this.containerLC);
        this.applicationLC.create();
    }

    private void testState(int applicationStarted, int applicationStopped, LifeCycleStatus applicationStatus, int containerStarted, int containerStopped, LifeCycleStatus containerStatus, int filterStarted, int filterStopped, LifeCycleStatus filterStatus) {
        Assert.assertEquals((Object)applicationStarted, (Object)this.application.getStarted());
        Assert.assertEquals((Object)applicationStopped, (Object)this.application.getStopped());
        Assert.assertEquals((Object)applicationStatus, (Object)this.applicationLC.getStatus());
        Assert.assertEquals((Object)containerStarted, (Object)this.container.getStarted());
        Assert.assertEquals((Object)containerStopped, (Object)this.container.getStopped());
        Assert.assertEquals((Object)containerStatus, (Object)this.containerLC.getStatus());
        Assert.assertEquals((Object)filterStarted, (Object)this.filter.getStarted());
        Assert.assertEquals((Object)filterStopped, (Object)this.filter.getStopped());
        Assert.assertEquals((Object)filterStatus, (Object)this.filterLC.getStatus());
    }

    @Test
    public void testWiring() {
        this.events.assertAddedEvent((ManagedObject)this.filterLC);
        this.events.assertAddedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        Assert.assertEquals((Object)1, (Object)this.application.containers.size());
        Assert.assertSame((Object)this.container, (Object)this.application.containers.get(this.container.getId()));
        Assert.assertEquals((Object)1, (Object)this.application.filters.size());
        Assert.assertSame((Object)this.filter, (Object)this.application.filters.get(this.filter.getId()));
        Assert.assertSame((Object)this.application, (Object)this.filter.application);
        Assert.assertSame((Object)this.application, (Object)this.container.application);
        Assert.assertEquals((Object)1, (Object)this.container.filters.size());
        Assert.assertSame((Object)this.filter, (Object)this.container.filters.get(this.filter.getId()));
    }

    @Test
    public void testApplicationLifeCycle() {
        this.events.clear();
        this.applicationLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, 1, 0, LifeCycleStatus.STARTED, 1, 0, LifeCycleStatus.STARTED);
        this.events.assertStartedEvent((ManagedObject)this.applicationLC);
        this.events.assertStartedEvent((ManagedObject)this.filterLC);
        this.events.assertStartedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.applicationLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, 1, 0, LifeCycleStatus.STARTED, 1, 0, LifeCycleStatus.STARTED);
        this.events.assertEmpty();
        this.applicationLC.managedStop();
        this.testState(1, 1, LifeCycleStatus.STOPPED, 1, 1, LifeCycleStatus.STOPPED, 1, 1, LifeCycleStatus.STOPPED);
        this.events.assertStoppedEvent((ManagedObject)this.containerLC);
        this.events.assertStoppedEvent((ManagedObject)this.filterLC);
        this.events.assertStoppedEvent((ManagedObject)this.applicationLC);
        this.events.assertEmpty();
    }

    @Test
    public void testFilterLifeCycle() {
        this.events.clear();
        this.applicationLC.managedStart();
        this.events.clear();
        this.filterLC.managedStop();
        this.testState(1, 0, LifeCycleStatus.STARTED, 1, 1, LifeCycleStatus.STOPPED, 1, 1, LifeCycleStatus.STOPPED);
        this.events.assertStoppedEvent((ManagedObject)this.containerLC);
        this.events.assertStoppedEvent((ManagedObject)this.filterLC);
        this.events.assertEmpty();
        this.containerLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, 1, 1, LifeCycleStatus.STOPPED, 1, 1, LifeCycleStatus.STOPPED);
        this.events.assertEmpty();
        this.filterLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, 2, 1, LifeCycleStatus.STARTED, 2, 1, LifeCycleStatus.STARTED);
        this.events.assertStartedEvent((ManagedObject)this.filterLC);
        this.events.assertStartedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
    }

    @Test
    public void testContainerLifeCycle() {
        this.events.clear();
        this.applicationLC.managedStart();
        this.events.clear();
        this.containerLC.managedStop();
        this.testState(1, 0, LifeCycleStatus.STARTED, 1, 1, LifeCycleStatus.STOPPED, 1, 0, LifeCycleStatus.STARTED);
        this.events.assertStoppedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.containerLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, 2, 1, LifeCycleStatus.STARTED, 1, 0, LifeCycleStatus.STARTED);
        this.events.assertStartedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
    }

    @Test
    public void testContainerFailsOnStart() {
        this.events.clear();
        this.container.startCallback = ObjectSupport.FAILURE_CALLBACK;
        this.applicationLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, 1, 0, LifeCycleStatus.FAILED, 1, 0, LifeCycleStatus.STARTED);
        this.events.assertStartedEvent((ManagedObject)this.applicationLC);
        this.events.assertStartedEvent((ManagedObject)this.filterLC);
        this.events.assertFailedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.applicationLC.managedStop();
        this.testState(1, 1, LifeCycleStatus.STOPPED, 1, 0, LifeCycleStatus.FAILED, 1, 1, LifeCycleStatus.STOPPED);
        this.events.assertStoppedEvent((ManagedObject)this.filterLC);
        this.events.assertStoppedEvent((ManagedObject)this.applicationLC);
        this.events.assertEmpty();
        this.applicationLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, 2, 0, LifeCycleStatus.FAILED, 2, 1, LifeCycleStatus.STARTED);
        this.events.assertStartedEvent((ManagedObject)this.applicationLC);
        this.events.assertStartedEvent((ManagedObject)this.filterLC);
        this.events.assertEmpty();
        this.containerLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, 3, 0, LifeCycleStatus.FAILED, 2, 1, LifeCycleStatus.STARTED);
        this.events.assertEmpty();
        this.containerLC.managedStop();
        this.testState(2, 1, LifeCycleStatus.STARTED, 3, 0, LifeCycleStatus.FAILED, 2, 1, LifeCycleStatus.STARTED);
        this.events.assertEmpty();
        this.filterLC.managedStop();
        this.testState(2, 1, LifeCycleStatus.STARTED, 3, 0, LifeCycleStatus.FAILED, 2, 2, LifeCycleStatus.STOPPED);
        this.events.assertStoppedEvent((ManagedObject)this.filterLC);
        this.events.assertEmpty();
        this.filterLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, 4, 0, LifeCycleStatus.FAILED, 3, 2, LifeCycleStatus.STARTED);
        this.events.assertStartedEvent((ManagedObject)this.filterLC);
        this.events.assertEmpty();
    }

    @Test
    public void testApplicationFailsOnStart() {
        this.events.clear();
        this.application.startCallback = ObjectSupport.FAILURE_CALLBACK;
        this.applicationLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.FAILED, 0, 0, LifeCycleStatus.STOPPED, 0, 0, LifeCycleStatus.STOPPED);
        this.events.assertFailedEvent((ManagedObject)this.applicationLC);
        this.events.assertEmpty();
        this.applicationLC.managedStart();
        this.testState(2, 0, LifeCycleStatus.FAILED, 0, 0, LifeCycleStatus.STOPPED, 0, 0, LifeCycleStatus.STOPPED);
        this.events.assertEmpty();
        this.applicationLC.managedStop();
        this.testState(2, 0, LifeCycleStatus.FAILED, 0, 0, LifeCycleStatus.STOPPED, 0, 0, LifeCycleStatus.STOPPED);
        this.events.assertEmpty();
    }

    @Test
    public void testFilterFailsOnStart() {
        this.events.clear();
        this.filter.startCallback = ObjectSupport.FAILURE_CALLBACK;
        this.applicationLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, 0, 0, LifeCycleStatus.STOPPED, 1, 0, LifeCycleStatus.FAILED);
        this.events.assertStartedEvent((ManagedObject)this.applicationLC);
        this.events.assertFailedEvent((ManagedObject)this.filterLC);
        this.events.assertEmpty();
        this.applicationLC.managedStop();
        this.testState(1, 1, LifeCycleStatus.STOPPED, 0, 0, LifeCycleStatus.STOPPED, 1, 0, LifeCycleStatus.FAILED);
        this.events.assertStoppedEvent((ManagedObject)this.applicationLC);
        this.events.assertEmpty();
        this.applicationLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, 0, 0, LifeCycleStatus.STOPPED, 2, 0, LifeCycleStatus.FAILED);
        this.events.assertStartedEvent((ManagedObject)this.applicationLC);
        this.events.assertEmpty();
        this.filterLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, 0, 0, LifeCycleStatus.STOPPED, 3, 0, LifeCycleStatus.FAILED);
        this.events.assertEmpty();
        this.filterLC.managedStop();
        this.testState(2, 1, LifeCycleStatus.STARTED, 0, 0, LifeCycleStatus.STOPPED, 3, 0, LifeCycleStatus.FAILED);
        this.events.assertEmpty();
        this.filterLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, 0, 0, LifeCycleStatus.STOPPED, 4, 0, LifeCycleStatus.FAILED);
        this.events.assertEmpty();
        this.containerLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, 0, 0, LifeCycleStatus.STOPPED, 4, 0, LifeCycleStatus.FAILED);
        this.events.assertEmpty();
    }

    @Test
    public void testContainerFailsOnStop() {
        this.container.stopCallback = ObjectSupport.FAILURE_CALLBACK;
        this.testApplicationLifeCycle();
    }

    @Test
    public void testApplicationFailsOnStop() {
        this.application.stopCallback = ObjectSupport.FAILURE_CALLBACK;
        this.testApplicationLifeCycle();
    }

    @Test
    public void testFilterFailsOnStop() {
        this.filter.stopCallback = ObjectSupport.FAILURE_CALLBACK;
        this.testApplicationLifeCycle();
    }
}

