/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.container;

import org.gatein.pc.portlet.container.ObjectSupport;
import org.gatein.pc.portlet.container.PortletApplicationContext;
import org.gatein.pc.portlet.container.PortletApplicationContextSupport;
import org.gatein.pc.portlet.container.PortletApplicationObjectSupport;
import org.gatein.pc.portlet.container.PortletContainerContext;
import org.gatein.pc.portlet.container.PortletContainerContextSupport;
import org.gatein.pc.portlet.container.PortletContainerObjectSupport;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.object.PortletApplicationObject;
import org.gatein.pc.portlet.container.object.PortletContainerObject;
import org.gatein.pc.portlet.impl.container.LifeCycle;
import org.gatein.pc.portlet.impl.container.PortletApplicationLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletContainerLifeCycle;
import org.jboss.unit.api.Assert;
import org.jboss.unit.api.pojo.annotations.Create;
import org.jboss.unit.api.pojo.annotations.Test;

@Test
public class LifeCycleReentranceDetectionTest {
    PortletApplicationLifeCycle applicationLF;
    PortletApplicationObjectSupport application;
    PortletContainerLifeCycle containerLF;
    PortletContainerObjectSupport container;
    IllegalStateException ise;

    @Create
    public void create() {
        this.ise = null;
    }

    @Test
    public void applicationReentersApplication1() {
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLF = new PortletApplicationLifeCycle((PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.application.startCallback = new InvokeLifeCycleCallback((LifeCycle)this.applicationLF, true, false);
        this.applicationLF.create();
        this.applicationLF.managedStart();
        Assert.assertNotNull((Object)this.ise);
        Assert.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.applicationLF.getStatus());
    }

    @Test
    public void applicationReentersApplication2() {
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLF = new PortletApplicationLifeCycle((PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.application.startCallback = new InvokeLifeCycleCallback((LifeCycle)this.applicationLF, true, true);
        this.applicationLF.create();
        this.applicationLF.managedStart();
        Assert.assertNotNull((Object)this.ise);
        Assert.assertEquals((Object)LifeCycleStatus.FAILED, (Object)this.applicationLF.getStatus());
    }

    @Test
    public void containerReentersContainer1() {
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLF = new PortletApplicationLifeCycle((PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.container = new PortletContainerObjectSupport("container");
        this.containerLF = this.applicationLF.addPortletContainer((PortletContainerContext)new PortletContainerContextSupport(), (PortletContainerObject)this.container);
        this.container.startCallback = new InvokeLifeCycleCallback((LifeCycle)this.containerLF, true, false);
        this.applicationLF.create();
        this.applicationLF.managedStart();
        Assert.assertNotNull((Object)this.ise);
        Assert.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.applicationLF.getStatus());
        Assert.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.containerLF.getStatus());
    }

    @Test
    public void containerReentersContainer2() {
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLF = new PortletApplicationLifeCycle((PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.container = new PortletContainerObjectSupport("container");
        this.containerLF = this.applicationLF.addPortletContainer((PortletContainerContext)new PortletContainerContextSupport(), (PortletContainerObject)this.container);
        this.container.startCallback = new InvokeLifeCycleCallback((LifeCycle)this.containerLF, true, true);
        this.applicationLF.create();
        this.applicationLF.managedStart();
        Assert.assertNotNull((Object)this.ise);
        Assert.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.applicationLF.getStatus());
        Assert.assertEquals((Object)LifeCycleStatus.FAILED, (Object)this.containerLF.getStatus());
    }

    @Test
    public void containerReentersApplication1() {
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLF = new PortletApplicationLifeCycle((PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.container = new PortletContainerObjectSupport("container");
        this.containerLF = this.applicationLF.addPortletContainer((PortletContainerContext)new PortletContainerContextSupport(), (PortletContainerObject)this.container);
        this.container.startCallback = new InvokeLifeCycleCallback((LifeCycle)this.applicationLF, true, false);
        this.applicationLF.create();
        this.applicationLF.managedStart();
        Assert.assertNotNull((Object)this.ise);
        Assert.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.applicationLF.getStatus());
        Assert.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.containerLF.getStatus());
    }

    @Test
    public void containerReentersApplication2() {
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLF = new PortletApplicationLifeCycle((PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.container = new PortletContainerObjectSupport("container");
        this.containerLF = this.applicationLF.addPortletContainer((PortletContainerContext)new PortletContainerContextSupport(), (PortletContainerObject)this.container);
        this.container.startCallback = new InvokeLifeCycleCallback((LifeCycle)this.applicationLF, true, true);
        this.applicationLF.create();
        this.applicationLF.managedStart();
        Assert.assertNotNull((Object)this.ise);
        Assert.assertEquals((Object)LifeCycleStatus.STARTED, (Object)this.applicationLF.getStatus());
        Assert.assertEquals((Object)LifeCycleStatus.FAILED, (Object)this.containerLF.getStatus());
    }

    private class InvokeLifeCycleCallback
    implements ObjectSupport.Callback {
        private LifeCycle lifeCycle;
        private boolean invokeStart;
        private boolean rethrowISE;

        private InvokeLifeCycleCallback(LifeCycle lifeCycle, boolean invokeStart, boolean rethrowISE) {
            this.lifeCycle = lifeCycle;
            this.invokeStart = invokeStart;
            this.rethrowISE = rethrowISE;
        }

        public void execute() {
            block4: {
                try {
                    if (this.invokeStart) {
                        this.lifeCycle.managedStart();
                    } else {
                        this.lifeCycle.managedStop();
                    }
                }
                catch (IllegalStateException e) {
                    LifeCycleReentranceDetectionTest.this.ise = e;
                    if (!this.rethrowISE) break block4;
                    throw e;
                }
            }
        }
    }
}

