/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.gatein.pc.portlet.impl.jsr168.ContentBuffer;
import org.jboss.unit.api.Assert;
import org.jboss.unit.api.pojo.annotations.Test;

@Test
public class ContentBufferTestCase {
    @Test
    public void testResetChars() {
        ContentBuffer buffer = new ContentBuffer();
        buffer.setContentType("text/html");
        PrintWriter writer = buffer.getWriter();
        writer.print("foo");
        buffer.reset();
        Assert.assertEquals((Object)"", (Object)buffer.getChars());
    }

    @Test
    public void testResetBytes() throws IOException {
        ContentBuffer buffer = new ContentBuffer();
        buffer.setContentType("text/html");
        OutputStream out = buffer.getOutputStream();
        out.write("foo".getBytes("UTF8"));
        buffer.reset();
        Assert.assertEquals((byte[])new byte[0], (byte[])buffer.getBytes());
    }

    @Test
    public void testResetAfterCommit() {
        ContentBuffer buffer = new ContentBuffer();
        buffer.setContentType("text/html");
        buffer.commit();
        try {
            buffer.reset();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testCommit() {
        ContentBuffer buffer = new ContentBuffer();
        buffer.setContentType("text/html");
        Assert.assertFalse((boolean)buffer.isCommited());
        buffer.commit();
        Assert.assertTrue((boolean)buffer.isCommited());
    }

    @Test
    public void testWriteCharsAfterCommit() {
        ContentBuffer buffer = new ContentBuffer();
        buffer.setContentType("text/html");
        buffer.commit();
        PrintWriter writer = buffer.getWriter();
        Assert.assertNotNull((Object)writer);
        writer.print("foo");
        writer.close();
        Assert.assertEquals((Object)"foo", (Object)buffer.getChars());
    }

    @Test
    public void testWriteCharsAndCommit() {
        ContentBuffer buffer = new ContentBuffer();
        buffer.setContentType("text/html");
        PrintWriter writer = buffer.getWriter();
        Assert.assertNotNull((Object)writer);
        writer.print("foo");
        buffer.commit();
        writer.print("bar");
        writer.close();
        Assert.assertEquals((Object)"foobar", (Object)buffer.getChars());
    }

    @Test
    public void testWriteBytesAfterCommit() throws IOException {
        ContentBuffer buffer = new ContentBuffer();
        buffer.setContentType("text/html");
        buffer.commit();
        OutputStream out = buffer.getOutputStream();
        Assert.assertNotNull((Object)out);
        out.write("foo".getBytes("UTF8"));
        out.close();
        Assert.assertEquals((byte[])"foo".getBytes("UTF8"), (byte[])buffer.getBytes());
    }

    @Test
    public void testWriteBytesAndCommit() throws IOException {
        ContentBuffer buffer = new ContentBuffer();
        buffer.setContentType("text/html");
        buffer.commit();
        OutputStream out = buffer.getOutputStream();
        out.write("foo".getBytes("UTF8"));
        Assert.assertNotNull((Object)out);
        out.write("bar".getBytes("UTF8"));
        out.close();
        Assert.assertEquals((byte[])"foobar".getBytes("UTF8"), (byte[])buffer.getBytes());
    }

    @Test
    public void testFlushWriterDoesCommit() {
        ContentBuffer buffer = new ContentBuffer();
        buffer.setContentType("text/html");
        PrintWriter writer = buffer.getWriter();
        writer.print("foo");
        writer.flush();
        Assert.assertTrue((boolean)buffer.isCommited());
    }

    @Test
    public void testCloseWriterDoesCommit() {
        ContentBuffer buffer = new ContentBuffer();
        buffer.setContentType("text/html");
        PrintWriter writer = buffer.getWriter();
        writer.print("foo");
        writer.close();
        Assert.assertTrue((boolean)buffer.isCommited());
    }

    @Test
    public void testFlushStreamDoesCommit() throws IOException {
        ContentBuffer buffer = new ContentBuffer();
        buffer.setContentType("text/html");
        OutputStream out = buffer.getOutputStream();
        out.write("foo".getBytes("UTF8"));
        out.flush();
        Assert.assertTrue((boolean)buffer.isCommited());
    }

    @Test
    public void testClosestreamDoesCommit() throws IOException {
        ContentBuffer buffer = new ContentBuffer();
        buffer.setContentType("text/html");
        OutputStream out = buffer.getOutputStream();
        out.write("foo".getBytes("UTF8"));
        out.close();
        Assert.assertTrue((boolean)buffer.isCommited());
    }
}

