/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.pc.api.info.NavigationInfo;
import org.gatein.pc.portlet.impl.jsr168.PortletParameterMap;
import org.gatein.pc.portlet.support.info.NavigationInfoSupport;
import org.gatein.pc.portlet.support.info.ParameterInfoSupport;
import org.jboss.unit.api.Assert;
import org.jboss.unit.api.pojo.annotations.Create;
import org.jboss.unit.api.pojo.annotations.Destroy;
import org.jboss.unit.api.pojo.annotations.Test;

@Test
public class ParametersTestCase {
    private NavigationInfoSupport navigation;
    private PortletParameterMap map;

    @Create
    public void setUp() {
        this.navigation = new NavigationInfoSupport();
        this.map = new PortletParameterMap((NavigationInfo)this.navigation);
    }

    @Destroy
    public void tearDown() {
        this.map = null;
        this.navigation = null;
    }

    @Test
    public void testGetWithNullName() {
        try {
            this.map.getParameterValue(null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSet() {
        this.map.setParameterValue("a", "b");
        Assert.assertEquals((Object)this.map.getParameterValue("a"), (Object)"b");
    }

    @Test
    public void testSetWithNullName() {
        try {
            this.map.setParameterValue(null, "b");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetWithNullValue() {
        try {
            this.map.setParameterValue("a", null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetValues() {
        this.map.setParameterValues("a", new String[]{"b", "c"});
        Assert.assertTrue((boolean)Arrays.equals(this.map.getParameterValues("a"), new String[]{"b", "c"}));
        Assert.assertEquals((Object)this.map.getParameterValue("a"), (Object)"b");
    }

    @Test
    public void testSetValuesWithNullName() {
        try {
            this.map.setParameterValues(null, new String[]{"a"});
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetValuesWithNullValues() {
        try {
            this.map.setParameterValues("a", null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetValuesWithZeroLengthValues() {
        try {
            this.map.setParameterValues("a", new String[0]);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetValuesWithOneNullValue() {
        try {
            this.map.setParameterValues("a", new String[]{"a", null});
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBlah() {
        this.navigation.addPublicParameter(new ParameterInfoSupport("foo", new QName("", "foo")));
        this.navigation.addPublicParameter(new ParameterInfoSupport("abc", new QName("", "abc")));
        this.map.setParameterValue("juu", "daa");
        this.map.setParameterValue("foo", "bar");
        this.map.removePublicParameterValue("abc");
        Map privateMap = this.map.getPrivateMapSnapshot();
        Assert.assertEquals((Object)1, (Object)privateMap.size());
        Assert.assertEquals((Object[])new String[]{"daa"}, (Object[])((Object[])privateMap.get("juu")));
        Assert.assertEquals(null, (Object[])((Object[])privateMap.get("abc")));
        Map publicMap = this.map.getPublicMapSnapshot();
        Assert.assertEquals((Object)2, (Object)publicMap.size());
        Assert.assertEquals((Object[])new String[]{"bar"}, (Object[])((Object[])publicMap.get("foo")));
        Assert.assertEquals((Object[])new String[0], (Object[])((Object[])publicMap.get("abc")));
        Map combinedMap = this.map.getMap();
        Assert.assertEquals((Object)2, (Object)combinedMap.size());
        Assert.assertEquals((Object[])new String[]{"bar"}, (Object[])((Object[])combinedMap.get("foo")));
        Assert.assertEquals((Object[])new String[]{"daa"}, (Object[])((Object[])combinedMap.get("juu")));
    }

    public Class[] buildExceptionClasses() {
        return new Class[]{NullPointerException.class, IllegalArgumentException.class, IllegalArgumentException.class, ClassCastException.class};
    }

    public Map[] buildInvalidMaps() {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("a", null);
        HashMap<String, String[]> map2 = new HashMap<String, String[]>();
        map2.put("a", new String[0]);
        HashMap<String, String[]> map3 = new HashMap<String, String[]>();
        map3.put("a", new String[]{null});
        HashMap<String, Object> map4 = new HashMap<String, Object>();
        map4.put("a", new Object());
        return new Map[]{map1, map2, map3, map4};
    }
}

