/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.info;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.info.CapabilitiesInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.WindowStateInfo;
import org.gatein.pc.portlet.container.managed.ManagedPortletContainer;
import org.gatein.pc.test.portlet.info.AbstractInfoTest;
import org.jboss.unit.api.Assert;

public class CapabilitiesInfoTest
extends AbstractInfoTest {
    public CapabilitiesInfoTest() {
        super("CapabilitiesInfoTest");
    }

    public void execute() {
        ManagedPortletContainer container = this.registry.getManagedPortletApplication("/test-info").getManagedPortletContainer("CapabilitiesPortlet");
        PortletInfo info = container.getInfo();
        CapabilitiesInfo capInfo = info.getCapabilities();
        Set allLocales = capInfo.getAllLocales();
        Assert.assertNotNull((Object)allLocales);
        Assert.assertTrue((boolean)allLocales.contains(Locale.ENGLISH));
        Set types = capInfo.getMediaTypes();
        Object[] mt = new String[types.size()];
        int count = 0;
        for (Object o : types) {
            mt[count++] = (String)o;
        }
        Assert.assertEquals((Object[])new String[]{"text/vnd.wap.wml", "text/html"}, (Object[])mt);
        Set modeInfos = capInfo.getAllModes();
        Set modes = this.extractModes(modeInfos);
        Assert.assertTrue((boolean)modes.contains(Mode.VIEW));
        Assert.assertTrue((boolean)modes.contains(Mode.HELP));
        Assert.assertTrue((boolean)modes.contains(Mode.EDIT));
        modeInfos = capInfo.getModes(MediaType.TEXT_HTML);
        modes = this.extractModes(modeInfos);
        Assert.assertEquals((Object)2, (Object)modes.size());
        Assert.assertTrue((boolean)modes.contains(Mode.VIEW));
        Assert.assertTrue((boolean)modes.contains(Mode.HELP));
        modeInfos = capInfo.getModes(MediaType.create((String)"text/vnd.wap.wml"));
        modes = this.extractModes(modeInfos);
        Assert.assertEquals((Object)2, (Object)modes.size());
        Assert.assertTrue((boolean)modes.contains(Mode.VIEW));
        Assert.assertTrue((boolean)modes.contains(Mode.EDIT));
        modeInfos = capInfo.getModes(MediaType.create((String)"text/undeclared"));
        modes = this.extractModes(modeInfos);
        Assert.assertEquals((Object)0, (Object)modes.size());
        Set stateInfos = capInfo.getAllWindowStates();
        Set states = this.extractWindowStates(stateInfos);
        Assert.assertEquals((Object)3, (Object)states.size());
        Assert.assertTrue((boolean)states.contains(WindowState.NORMAL));
        Assert.assertTrue((boolean)states.contains(WindowState.MINIMIZED));
        Assert.assertTrue((boolean)states.contains(WindowState.MAXIMIZED));
        stateInfos = capInfo.getWindowStates(MediaType.TEXT_HTML);
        states = this.extractWindowStates(stateInfos);
        Assert.assertEquals((Object)3, (Object)states.size());
        Assert.assertTrue((boolean)states.contains(WindowState.NORMAL));
        Assert.assertTrue((boolean)states.contains(WindowState.MINIMIZED));
        Assert.assertTrue((boolean)states.contains(WindowState.MAXIMIZED));
        states = capInfo.getWindowStates(MediaType.create((String)"text/vnd.wap.wml"));
        Assert.assertEquals((Object)3, (Object)states.size());
        states = capInfo.getWindowStates(MediaType.create((String)"undeclared/mime"));
        Assert.assertEquals((Object)0, (Object)states.size());
    }

    public Set extractWindowStates(Set infos) {
        HashSet<WindowState> states = new HashSet<WindowState>();
        for (WindowStateInfo info : infos) {
            WindowState state = info.getWindowState();
            Assert.assertEquals((Object)state.toString(), (Object)info.getWindowStateName());
            states.add(state);
        }
        return states;
    }

    public Set extractModes(Set infos) {
        HashSet<Mode> modes = new HashSet<Mode>();
        for (ModeInfo info : infos) {
            Mode mode = info.getMode();
            Assert.assertEquals((Object)mode.toString(), (Object)info.getModeName());
            modes.add(mode);
        }
        return modes;
    }
}

