/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.info;

import java.util.HashSet;
import java.util.Set;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.info.CapabilitiesInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.portlet.container.managed.ManagedPortletContainer;
import org.gatein.pc.test.portlet.info.AbstractInfoTest;
import org.jboss.unit.api.Assert;

public class ModeInfoTest
extends AbstractInfoTest {
    public ModeInfoTest() {
        super("ModeInfoTest");
    }

    public void execute() {
        ManagedPortletContainer container1 = this.registry.getManagedPortletApplication("/test-info").getManagedPortletContainer("ModePortlet1");
        ManagedPortletContainer container2 = this.registry.getManagedPortletApplication("/test-info").getManagedPortletContainer("ModePortlet2");
        CapabilitiesInfo capaInfo = container1.getInfo().getCapabilities();
        Set modeInfos = capaInfo.getModes(MediaType.TEXT_HTML);
        Assert.assertEquals((Object)3, (Object)modeInfos.size());
        HashSet<Mode> portletModes = new HashSet<Mode>();
        for (ModeInfo mode : modeInfos) {
            portletModes.add(mode.getMode());
            Assert.assertEquals((Object)mode.getModeName(), (Object)mode.getMode().toString());
        }
        Assert.assertTrue((boolean)portletModes.contains(Mode.VIEW));
        Assert.assertTrue((boolean)portletModes.contains(Mode.HELP));
        Assert.assertTrue((boolean)portletModes.contains(Mode.EDIT));
        capaInfo = container2.getInfo().getCapabilities();
        modeInfos = capaInfo.getModes(MediaType.TEXT_HTML);
        Assert.assertEquals((Object)1, (Object)modeInfos.size());
        portletModes = new HashSet();
        for (ModeInfo mode : modeInfos) {
            portletModes.add(mode.getMode());
            Assert.assertEquals((Object)mode.getModeName(), (Object)mode.getMode().toString());
        }
        Assert.assertTrue((boolean)portletModes.contains(Mode.VIEW));
        Assert.assertTrue((!portletModes.contains(Mode.HELP) ? 1 : 0) != 0);
        Assert.assertTrue((!portletModes.contains(Mode.EDIT) ? 1 : 0) != 0);
    }
}

