/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.info;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.portlet.container.managed.ManagedPortletContainer;
import org.gatein.pc.portlet.impl.info.ContainerPreferenceInfo;
import org.gatein.pc.portlet.impl.info.ContainerPreferencesInfo;
import org.gatein.pc.test.portlet.info.AbstractInfoTest;
import org.jboss.unit.api.Assert;

public class PreferenceInfoTest
extends AbstractInfoTest {
    public PreferenceInfoTest() {
        super("PreferenceInfoTest");
    }

    public void execute() {
        ManagedPortletContainer container = this.registry.getManagedPortletApplication("/test-info").getManagedPortletContainer("PreferenceInfoPortlet");
        PortletInfo info = container.getInfo();
        ContainerPreferencesInfo prefsInfo = (ContainerPreferencesInfo)info.getPreferences();
        ContainerPreferenceInfo prefInfo = prefsInfo.getContainerPreference("localized_pref");
        Assert.assertEquals((Object)"localized_pref", (Object)prefInfo.getKey());
        Assert.assertEquals((Object)"english localized description", (Object)prefInfo.getDescription().getString(Locale.ENGLISH, false));
        Assert.assertEquals((Object)"polish localized description", (Object)prefInfo.getDescription().getString(new Locale("pl"), false));
        Assert.assertEquals((Object)"english_localized_name", (Object)prefInfo.getDisplayName().getString(Locale.ENGLISH, false));
        Assert.assertEquals((Object)"polish_localized_name", (Object)prefInfo.getDisplayName().getString(new Locale("pl"), false));
        Set keys = prefsInfo.getKeys();
        Assert.assertTrue((boolean)keys.contains("localized_pref"));
        Assert.assertTrue((boolean)keys.contains("single_pref"));
        Assert.assertTrue((boolean)keys.contains("multi_pref"));
        Assert.assertTrue((boolean)keys.contains("single_pref_bis"));
        Assert.assertTrue((boolean)keys.contains("multi_pref_bis"));
        prefInfo = prefsInfo.getContainerPreference("single_pref");
        Assert.assertEquals((Object)"single_pref", (Object)prefInfo.getKey());
        List values = prefInfo.getDefaultValue();
        Assert.assertEquals(Arrays.asList("single_pref_value"), (Object)values);
        Assert.assertTrue((prefInfo.isReadOnly() == false ? 1 : 0) != 0);
        prefInfo = prefsInfo.getContainerPreference("multi_pref");
        Assert.assertEquals((Object)"multi_pref", (Object)prefInfo.getKey());
        values = prefInfo.getDefaultValue();
        Assert.assertEquals(Arrays.asList("multi_pref_value_1", "multi_pref_value_2"), (Object)values);
        Assert.assertTrue((prefInfo.isReadOnly() == false ? 1 : 0) != 0);
        prefInfo = prefsInfo.getContainerPreference("single_pref_bis");
        Assert.assertEquals((Object)"single_pref_bis", (Object)prefInfo.getKey());
        values = prefInfo.getDefaultValue();
        Assert.assertEquals(Arrays.asList("single_pref_value"), (Object)values);
        Assert.assertTrue((boolean)prefInfo.isReadOnly());
        prefInfo = prefsInfo.getContainerPreference("multi_pref_bis");
        Assert.assertEquals((Object)"multi_pref_bis", (Object)prefInfo.getKey());
        values = prefInfo.getDefaultValue();
        Assert.assertEquals(Arrays.asList("multi_pref_value_1", "multi_pref_value_2"), (Object)values);
        Assert.assertTrue((boolean)prefInfo.isReadOnly());
    }
}

