/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.state;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.util.Tools;
import org.gatein.pc.api.InvalidPortletIdException;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.state.AbstractPropertyContext;
import org.gatein.pc.portlet.state.SimplePropertyMap;
import org.gatein.pc.portlet.support.PortletSupport;
import org.gatein.pc.portlet.support.info.PortletInfoSupport;
import org.gatein.pc.test.portlet.state.ValueMapAssert;
import org.jboss.unit.api.Assert;
import org.jboss.unit.api.pojo.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStatefulPortletInvokerTestCase {
    protected final boolean persistLocally;

    protected AbstractStatefulPortletInvokerTestCase(boolean persistLocally) {
        this.persistLocally = persistLocally;
    }

    protected abstract PortletSupport getPortletSupport(PortletContext var1) throws PortletInvokerException;

    protected abstract Portlet getPortlet(PortletContext var1) throws PortletInvokerException;

    protected abstract String getPortletId(PortletContext var1) throws PortletInvokerException;

    protected abstract PortletContext createPOPRef(PortletInfoSupport var1) throws PortletInvokerException;

    protected abstract PortletContext createNonExistingPOPRef() throws PortletInvokerException;

    protected abstract PortletContext createInvalidPOPRef() throws PortletInvokerException;

    protected abstract PortletContext createLocalClone(PortletContext var1) throws Exception;

    protected abstract void destroyClone(PortletContext var1) throws Exception;

    protected abstract PortletContext createClone(PortletContext var1) throws PortletInvokerException;

    protected abstract PortletContext setProperties(PortletContext var1, PropertyChange[] var2) throws PortletInvokerException;

    protected abstract PropertyMap getProperties(PortletContext var1) throws PortletInvokerException;

    protected abstract PropertyMap getProperties(PortletContext var1, Set var2) throws PortletInvokerException;

    protected abstract List destroyClones(List var1) throws PortletInvokerException;

    protected abstract void assertNoExistingState();

    protected abstract void invoke(PortletInvocation var1) throws PortletInvokerException;

    protected abstract ActionInvocation createAction(PortletContext var1, AccessMode var2);

    protected abstract PortletContext getImplicitClonedRef(ActionInvocation var1);

    protected abstract PortletContext getModifiedPortletRef(ActionInvocation var1);

    protected abstract void addPreference(PortletContext var1, String var2, List<String> var3);

    protected abstract void addPreference(PortletContext var1, String var2, List<String> var3, Boolean var4);

    protected final void assertCloneDoesNotExist(PortletContext ref) {
        if (this.persistLocally) {
            try {
                this.getProperties(ref);
                Assert.fail((String)"Was expecting a NoSuchPortletException to be thrown");
            }
            catch (NoSuchPortletException expected) {
            }
            catch (PortletInvokerException e) {
                Assert.fail((Throwable)e);
            }
        } else {
            try {
                this.getProperties(ref);
            }
            catch (PortletInvokerException e) {
                Assert.fail((Throwable)e);
            }
        }
    }

    protected final PortletContext createLocalCCPRef() throws Exception {
        PortletContext popCtx = this.createPOPRef();
        return this.createLocalClone(popCtx);
    }

    protected final PortletContext createNonExistingLocalCCPRef() throws Exception {
        PortletContext popRef = this.createPOPRef();
        PortletContext ccpRef = this.createLocalClone(popRef);
        this.destroyClone(ccpRef);
        return ccpRef;
    }

    protected final PortletContext createPOPRef() throws PortletInvokerException {
        PortletInfoSupport info = new PortletInfoSupport();
        return this.createPOPRef(info);
    }

    @Test
    public void testCloneWithNullContext() throws Exception {
        try {
            this.createClone(null);
            Assert.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    @Test
    public void testCloneNonExistingPOP() throws Exception {
        PortletContext popCtx = this.createNonExistingPOPRef();
        try {
            this.createClone(popCtx);
            Assert.fail((String)"was expecting an NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    @Test
    public void testCloneNonExistingCCP() throws Exception {
        PortletContext ccpCtx = this.createNonExistingLocalCCPRef();
        try {
            this.createClone(ccpCtx);
            Assert.fail((String)"was expecting an NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    @Test
    public void testCloneInvalidPOP() throws Exception {
        PortletContext popCtx = this.createInvalidPOPRef();
        try {
            this.createClone(popCtx);
            Assert.fail((String)"was expecting an InvalidPortletIdException");
        }
        catch (InvalidPortletIdException invalidPortletIdException) {
            // empty catch block
        }
        this.assertNoExistingState();
    }

    @Test
    public void testClonePortlet() throws Exception {
        PortletInfoSupport info = new PortletInfoSupport();
        info.getMeta().setDisplayName("MyPortlet");
        PortletContext popCtx = this.createPOPRef(info);
        this.addPreference(popCtx, "abc", Arrays.asList("def"));
        PortletContext ccp1Ctx = this.createClone(popCtx);
        SimplePropertyMap expected = new SimplePropertyMap();
        expected.setProperty("abc", Arrays.asList("def"));
        PropertyMap ccp1Props = this.getProperties(ccp1Ctx);
        ValueMapAssert.assertEquals((PropertyMap)expected, ccp1Props);
        Portlet ccp1 = this.getPortlet(ccp1Ctx);
        LocalizedString abc = ccp1.getInfo().getMeta().getMetaValue("display-name");
        Assert.assertEquals((Object)"MyPortlet", (Object)abc.getString(Locale.ENGLISH, true));
        this._assertEquals(ccp1Ctx, ccp1.getContext());
        PropertyChange[] changes = new PropertyChange[]{PropertyChange.newUpdate((String)"ghi", Arrays.asList("jkl"))};
        ccp1Ctx = this.setProperties(ccp1Ctx, changes);
        PortletContext ccp2Ctx = this.createClone(ccp1Ctx);
        expected = new SimplePropertyMap();
        expected.setProperty("abc", Arrays.asList("def"));
        expected.setProperty("ghi", Arrays.asList("jkl"));
        PropertyMap ccp2Props = this.getProperties(ccp2Ctx);
        ValueMapAssert.assertEquals((PropertyMap)expected, ccp2Props);
        Portlet ccp2 = this.getPortlet(ccp2Ctx);
        LocalizedString def = ccp2.getInfo().getMeta().getMetaValue("display-name");
        Assert.assertEquals((Object)"MyPortlet", (Object)def.getString(Locale.ENGLISH, true));
    }

    @Test
    public void testGetWithNullId() throws Exception {
        try {
            this.getPortlet(null);
            Assert.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNonExistingPOP() throws Exception {
        PortletContext pop = this.createNonExistingPOPRef();
        try {
            this.getPortlet(pop);
            Assert.fail((String)"was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNonExistingCCP() throws Exception {
        PortletContext ccpCtx = this.createNonExistingLocalCCPRef();
        try {
            this.getPortlet(ccpCtx);
            Assert.fail((String)"was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
    }

    @Test
    public void testGetInvalidPOP() throws Exception {
        PortletContext popCtx = this.createInvalidPOPRef();
        try {
            this.getPortlet(popCtx);
            Assert.fail((String)"was expecting an InvalidPortletIdException");
        }
        catch (InvalidPortletIdException invalidPortletIdException) {
            // empty catch block
        }
    }

    @Test
    public void testDestroyWithNullId() throws Exception {
        try {
            this.destroyClones(null);
            Assert.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDestroyPOP() throws Exception {
        PortletContext popCtx = this.createPOPRef();
        List failures = this.destroyClones(Collections.singletonList(popCtx));
        Assert.assertEquals((Object)1, (Object)failures.size());
        DestroyCloneFailure failure = (DestroyCloneFailure)failures.get(0);
        Assert.assertEquals((Object)this.getPortletId(popCtx), (Object)failure.getPortletId());
    }

    @Test
    public void testDestroyCCP() throws Exception {
        PortletContext popCtx = this.createPOPRef();
        PortletContext ccpCtx = this.createClone(popCtx);
        List failures = this.destroyClones(Collections.singletonList(ccpCtx));
        Assert.assertEquals((Object)0, (Object)failures.size());
        this.assertNoExistingState();
    }

    @Test
    public void testDestroyNonExistingCCP() throws Exception {
        PortletContext ccpCtx = this.createNonExistingLocalCCPRef();
        List failures = this.destroyClones(Collections.singletonList(ccpCtx));
        Assert.assertEquals((Object)1, (Object)failures.size());
        DestroyCloneFailure failure = (DestroyCloneFailure)failures.get(0);
        Assert.assertEquals((Object)this.getPortletId(ccpCtx), (Object)failure.getPortletId());
    }

    @Test
    public void testGetPropertiesWithNullPortlet() throws Exception {
        try {
            this.getProperties(null);
            Assert.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.getProperties(null, new HashSet());
            Assert.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNonExistingPOPProperties() throws Exception {
        PortletContext popCtx = this.createNonExistingPOPRef();
        try {
            this.getProperties(popCtx);
            Assert.fail((String)"was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException e) {
            // empty catch block
        }
        try {
            this.getProperties(popCtx, new HashSet());
            Assert.fail((String)"was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
    }

    @Test
    public void testGetInvalidPOPProperties() throws Exception {
        PortletContext popCtx = this.createInvalidPOPRef();
        try {
            this.getProperties(popCtx);
            Assert.fail((String)"was expecting an InvalidPortletIdException");
        }
        catch (InvalidPortletIdException e) {
            // empty catch block
        }
        try {
            this.getProperties(popCtx, new HashSet());
            Assert.fail((String)"was expecting an InvalidPortletIdException");
        }
        catch (InvalidPortletIdException invalidPortletIdException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNonExistingCCPProperties() throws Exception {
        PortletContext ccpCtx = this.createNonExistingLocalCCPRef();
        try {
            this.getProperties(ccpCtx);
            Assert.fail((String)"was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException e) {
            // empty catch block
        }
        try {
            this.getProperties(ccpCtx, new HashSet());
            Assert.fail((String)"was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPOPWithNullKeys() throws Exception {
        PortletContext popCtx = this.createPOPRef();
        try {
            this.getProperties(popCtx, null);
            Assert.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetCCPWithNullKeys() throws Exception {
        PortletContext ccpCtx = this.createLocalCCPRef();
        try {
            this.getProperties(ccpCtx, null);
            Assert.fail((String)"was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPOPProperties() throws Exception {
        PortletInfoSupport info = new PortletInfoSupport();
        PortletContext popCtx = this.createPOPRef(info);
        this.addPreference(popCtx, "abc", Arrays.asList("def"));
        this.addPreference(popCtx, "ghi", Arrays.asList("jkl"), Boolean.TRUE);
        PropertyMap props = this.getProperties(popCtx);
        SimplePropertyMap expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("abc", Arrays.asList("def"));
        expectedProps.setProperty("ghi", Arrays.asList("jkl"));
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, props);
        props = this.getProperties(popCtx, Tools.toSet((Object[])new String[]{"abc", "mno"}));
        expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("abc", Arrays.asList("def"));
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, props);
    }

    @Test
    public void testGetCCPProperties() throws Exception {
        PortletInfoSupport info = new PortletInfoSupport();
        PortletContext popCtx = this.createPOPRef(info);
        this.addPreference(popCtx, "abc", Arrays.asList("def"));
        this.addPreference(popCtx, "ghi", Arrays.asList("jkl"));
        this.addPreference(popCtx, "mno", Arrays.asList("pqr"), Boolean.TRUE);
        this.addPreference(popCtx, "stu", Arrays.asList("vwx"), Boolean.TRUE);
        PortletContext ccpCtx = this.createClone(popCtx);
        ccpCtx = this.setProperties(ccpCtx, new PropertyChange[]{PropertyChange.newUpdate((String)"abc", Arrays.asList("_def")), PropertyChange.newReset((String)"gho"), PropertyChange.newUpdate((String)"mno", Arrays.asList("_pqr")), PropertyChange.newReset((String)"stu")});
        PropertyMap props = this.getProperties(ccpCtx);
        SimplePropertyMap expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("abc", Arrays.asList("_def"));
        expectedProps.setProperty("ghi", Arrays.asList("jkl"));
        expectedProps.setProperty("mno", Arrays.asList("pqr"));
        expectedProps.setProperty("stu", Arrays.asList("vwx"));
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, props);
        props = this.getProperties(ccpCtx, Tools.toSet((Object[])new String[]{"abc", "mno", "yz"}));
        expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("abc", Arrays.asList("_def"));
        expectedProps.setProperty("mno", Arrays.asList("pqr"));
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, props);
    }

    @Test
    public void testSetPropertiesWithNullId() throws Exception {
        try {
            this.setProperties(null, new PropertyChange[0]);
            Assert.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetPropertiesWithNullProperties() throws Exception {
        PortletContext ccpCtx = this.createLocalCCPRef();
        try {
            this.setProperties(ccpCtx, null);
            Assert.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetPOPProperties() throws Exception {
        PortletContext popCtx = this.createPOPRef();
        try {
            this.setProperties(popCtx, new PropertyChange[0]);
            Assert.fail((String)"Was expecting an InvalidPortletIdException");
        }
        catch (InvalidPortletIdException invalidPortletIdException) {
            // empty catch block
        }
    }

    @Test
    public void testSetNonExistingCCPProperties() throws Exception {
        PortletContext ccpCtx = this.createNonExistingLocalCCPRef();
        try {
            this.setProperties(ccpCtx, new PropertyChange[0]);
            Assert.fail((String)"Was expecting a NoSuchPortletException");
        }
        catch (NoSuchPortletException noSuchPortletException) {
            // empty catch block
        }
    }

    @Test
    public void testSetCCPProperties() throws Exception {
        PortletInfoSupport info = new PortletInfoSupport();
        PortletContext popCtx = this.createPOPRef(info);
        this.addPreference(popCtx, "override_update", Arrays.asList("override_update_portlet_value"));
        this.addPreference(popCtx, "override_reset", Arrays.asList("override_reset_portlet_value"));
        this.addPreference(popCtx, "override_create", Arrays.asList("override_create_portlet_value"));
        this.addPreference(popCtx, "readonly_create", Arrays.asList("readonly_create_portlet_value"), Boolean.TRUE);
        PortletContext ccpCtx = this.createClone(popCtx);
        ccpCtx = this.setProperties(ccpCtx, new PropertyChange[]{PropertyChange.newUpdate((String)"override_update", Arrays.asList("override_update_clone_value")), PropertyChange.newUpdate((String)"override_reset", Arrays.asList("override_reset_clone_value")), PropertyChange.newUpdate((String)"dynamic_update", Arrays.asList("dynamic_update_clone_value")), PropertyChange.newUpdate((String)"dynamic_reset", Arrays.asList("dynamic_reset_clone_value"))});
        SimplePropertyMap expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("override_update", Arrays.asList("override_update_clone_value"));
        expectedProps.setProperty("override_reset", Arrays.asList("override_reset_clone_value"));
        expectedProps.setProperty("override_create", Arrays.asList("override_create_portlet_value"));
        expectedProps.setProperty("readonly_create", Arrays.asList("readonly_create_portlet_value"));
        expectedProps.setProperty("dynamic_update", Arrays.asList("dynamic_update_clone_value"));
        expectedProps.setProperty("dynamic_reset", Arrays.asList("dynamic_reset_clone_value"));
        PropertyMap ccpProps = this.getProperties(ccpCtx);
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, ccpProps);
        PropertyChange[] changes = new PropertyChange[]{PropertyChange.newUpdate((String)"override_update", Arrays.asList("override_update_clone_value_2")), PropertyChange.newReset((String)"override_reset"), PropertyChange.newUpdate((String)"override_create", Arrays.asList("override_create_clone_value_2")), PropertyChange.newUpdate((String)"dynamic_update", Arrays.asList("dynamic_update_clone_value_2")), PropertyChange.newReset((String)"dynamic_reset"), PropertyChange.newUpdate((String)"dynamic_create", Arrays.asList("dynamic_create_clone_value_2")), PropertyChange.newUpdate((String)"readonly_create", Arrays.asList("readonly_create_clone_value_2"))};
        ccpCtx = this.setProperties(ccpCtx, changes);
        expectedProps.clear();
        expectedProps.setProperty("override_update", Arrays.asList("override_update_clone_value_2"));
        expectedProps.setProperty("override_create", Arrays.asList("override_create_clone_value_2"));
        expectedProps.setProperty("override_reset", Arrays.asList("override_reset_portlet_value"));
        expectedProps.setProperty("dynamic_update", Arrays.asList("dynamic_update_clone_value_2"));
        expectedProps.setProperty("dynamic_create", Arrays.asList("dynamic_create_clone_value_2"));
        expectedProps.setProperty("readonly_create", Arrays.asList("readonly_create_portlet_value"));
        ccpProps = this.getProperties(ccpCtx);
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, ccpProps);
    }

    @Test
    public void testInvokeCloneBeforeWritePOPWithUpdate() throws Exception {
        this.invokeCloneBeforeWriteWithUpdate(true);
    }

    @Test
    public void testInvokeCloneBeforeWriteCCPWithUpdate() throws Exception {
        this.invokeCloneBeforeWriteWithUpdate(false);
    }

    public void invokeCloneBeforeWriteWithUpdate(boolean pop) throws Exception {
        PortletContext ctx;
        PortletSupport portletSupport;
        PortletContext popCtx;
        PortletInfoSupport info = new PortletInfoSupport();
        PortletSupport.InvocationHandler handler = new PortletSupport.InvocationHandler(){

            public PortletInvocationResponse invoke(PortletInvocation invocation) {
                AbstractPropertyContext props = (AbstractPropertyContext)invocation.getAttribute("preferences");
                props.update(new PropertyChange[]{PropertyChange.newUpdate((String)"abc", Arrays.asList("_def"))});
                return null;
            }
        };
        if (pop) {
            popCtx = this.createPOPRef(info);
            portletSupport = this.getPortletSupport(popCtx);
            portletSupport.addHandler(handler);
            this.addPreference(popCtx, "abc", Arrays.asList("def"));
            ctx = popCtx;
        } else {
            PortletContext ccpCtx;
            popCtx = this.createPOPRef(info);
            portletSupport = this.getPortletSupport(popCtx);
            portletSupport.addHandler(handler);
            this.addPreference(popCtx, "abc", Arrays.asList("def"));
            ctx = ccpCtx = this.createClone(popCtx);
        }
        ActionInvocation invocation = this.createAction(ctx, AccessMode.CLONE_BEFORE_WRITE);
        this.invoke((PortletInvocation)invocation);
        PortletContext cloneRef = this.getImplicitClonedRef(invocation);
        Assert.assertNotNull((Object)cloneRef);
        PropertyMap blah = this.getProperties(cloneRef);
        SimplePropertyMap expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("abc", Arrays.asList("_def"));
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, blah);
        this.destroyClone(cloneRef);
        this.assertCloneDoesNotExist(cloneRef);
    }

    @Test
    public void testInvokeReadOnlyWithUpdate() throws Exception {
        final Boolean[] ise = new Boolean[]{Boolean.FALSE};
        PortletInfoSupport info = new PortletInfoSupport();
        PortletSupport.InvocationHandler handler = new PortletSupport.InvocationHandler(){

            public PortletInvocationResponse invoke(PortletInvocation invocation) {
                try {
                    AbstractPropertyContext props = (AbstractPropertyContext)invocation.getAttribute("preferences");
                    props.update(new PropertyChange[]{PropertyChange.newUpdate((String)"abc", Arrays.asList("_def"))});
                    return null;
                }
                catch (IllegalStateException e) {
                    ise[0] = Boolean.TRUE;
                    return null;
                }
            }
        };
        PortletContext popCtx = this.createPOPRef(info);
        PortletSupport portletSupport = this.getPortletSupport(popCtx);
        portletSupport.addHandler(handler);
        this.addPreference(popCtx, "abc", Arrays.asList("def"));
        ActionInvocation invocation = this.createAction(popCtx, AccessMode.READ_ONLY);
        this.invoke((PortletInvocation)invocation);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ise[0]);
    }

    @Test
    public void testInvokeReadWriteWithUpdate() throws Exception {
        PortletInfoSupport info = new PortletInfoSupport();
        PortletSupport.InvocationHandler handler = new PortletSupport.InvocationHandler(){

            public PortletInvocationResponse invoke(PortletInvocation invocation) {
                AbstractPropertyContext props = (AbstractPropertyContext)invocation.getAttribute("preferences");
                props.update(new PropertyChange[]{PropertyChange.newUpdate((String)"abc", Arrays.asList("_def"))});
                return null;
            }
        };
        PortletContext popCtx = this.createPOPRef(info);
        PortletSupport portletSupport = this.getPortletSupport(popCtx);
        portletSupport.addHandler(handler);
        this.addPreference(popCtx, "abc", Arrays.asList("def"));
        PortletContext ccpCtx = this.createClone(popCtx);
        ActionInvocation invocation = this.createAction(ccpCtx, AccessMode.READ_WRITE);
        this.invoke((PortletInvocation)invocation);
        ccpCtx = this.getModifiedPortletRef(invocation);
        Assert.assertNotNull((Object)ccpCtx);
        PropertyMap blah = this.getProperties(ccpCtx);
        SimplePropertyMap expectedProps = new SimplePropertyMap();
        expectedProps.setProperty("abc", Arrays.asList("_def"));
        ValueMapAssert.assertEquals((PropertyMap)expectedProps, blah);
    }

    private void _assertEquals(PortletContext expected, PortletContext actual) {
        if (expected == null) {
            Assert.assertNull((String)"Portlet context should be null", (Object)actual);
        } else {
            Assert.assertNotNull((String)("Portlet context should not be null but rather equals to " + expected), (Object)actual);
            Assert.assertEquals((Object)expected.getId(), (Object)actual.getId());
            Serializable expectedState = null;
            Serializable actualState = null;
            if (expected instanceof StatefulPortletContext) {
                expectedState = ((StatefulPortletContext)expected).getState();
            }
            if (actual instanceof StatefulPortletContext) {
                actualState = ((StatefulPortletContext)actual).getState();
            }
            if (expectedState == null) {
                Assert.assertNull((String)"Actual state should be null", (Object)actualState);
            } else {
                Assert.assertNotNull((String)"Actual state should be not null", (Object)actualState);
                Assert.assertTrue((boolean)expectedState.equals(actualState));
            }
        }
    }
}

